/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.collection.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import java.io.Serializable;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractUnmodifiableIntCollection
implements MutableIntCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntCollection collection;

    protected AbstractUnmodifiableIntCollection(MutableIntCollection collection) {
        this.collection = collection;
    }

    protected MutableIntCollection getIntCollection() {
        return this.collection;
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public boolean notEmpty() {
        return this.collection.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(int value) {
        return this.collection.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.collection.containsAll(source);
    }

    public boolean add(int newItem) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(int ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(IntIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(int value) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(IntIterable source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(int ... source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(IntIterable source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(int ... source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public IntIterator intIterator() {
        return this.collection.intIterator();
    }

    public void forEach(IntProcedure procedure) {
        this.collection.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableIntCollection select(IntPredicate predicate) {
        return this.collection.select(predicate);
    }

    public MutableIntCollection reject(IntPredicate predicate) {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return this.collection.collect(function);
    }

    public MutableIntCollection with(int element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableIntCollection without(int element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableIntCollection withAll(IntIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableIntCollection withoutAll(IntIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableIntCollection asUnmodifiable() {
        return this;
    }

    public MutableIntCollection asSynchronized() {
        return new SynchronizedIntCollection(this);
    }

    public ImmutableIntCollection toImmutable() {
        return this.collection.toImmutable();
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.collection.sum();
    }

    public int max() {
        return this.collection.max();
    }

    public int min() {
        return this.collection.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.collection.minIfEmpty(defaultValue);
    }

    public int maxIfEmpty(int defaultValue) {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.collection.average();
    }

    public double median() {
        return this.collection.median();
    }

    public MutableIntList toSortedList() {
        return this.collection.toSortedList();
    }

    public int[] toSortedArray() {
        return this.collection.toSortedArray();
    }

    public int[] toArray() {
        return this.collection.toArray();
    }

    public String toString() {
        return this.collection.toString();
    }

    public String makeString() {
        return this.collection.makeString();
    }

    public String makeString(String separator) {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableIntList toList() {
        return this.collection.toList();
    }

    public MutableIntSet toSet() {
        return this.collection.toSet();
    }

    public MutableIntBag toBag() {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.collection.injectInto(injectedValue, function);
    }
}

