/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Query;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Index
implements Serializable {
    private static final long serialVersionUID = 8595801877003574982L;
    private long id;
    private String kind;
    private boolean isAncestor;
    private List<Property> properties;

    private Index() {
    }

    Index(long id, String kind, boolean isAncestor, List<Property> properties) {
        if (kind == null) {
            throw new NullPointerException("kind must not be null");
        }
        if (properties == null) {
            throw new NullPointerException("properties must not be null");
        }
        this.id = id;
        this.kind = kind;
        this.isAncestor = isAncestor;
        this.properties = properties;
    }

    public long getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean isAncestor() {
        return this.isAncestor;
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Index) {
            Index other = (Index)obj;
            return this.id == other.id && this.kind.equals(other.kind) && this.isAncestor == other.isAncestor && this.properties.equals(other.properties);
        }
        return false;
    }

    public int hashCode() {
        int result = Long.valueOf(this.id).hashCode();
        result = result * 31 + this.properties.hashCode();
        result = result * 31 + this.kind.hashCode();
        return result * 31 + Boolean.valueOf(this.isAncestor).hashCode();
    }

    public String toString() {
        StringBuilder stBuilder = new StringBuilder("INDEX [").append(this.id).append("] ON ").append(this.kind).append('(');
        if (!this.properties.isEmpty()) {
            for (Property property : this.properties) {
                stBuilder.append(property).append(", ");
            }
            stBuilder.setLength(stBuilder.length() - 2);
        }
        stBuilder.append(")");
        if (this.isAncestor) {
            stBuilder.append(" INCLUDES ANCESTORS");
        }
        return stBuilder.toString();
    }

    public static class Property
    implements Serializable {
        private static final long serialVersionUID = -5946842287951548217L;
        private String name;
        private Query.SortDirection direction;

        private Property() {
        }

        Property(String name, Query.SortDirection direction) {
            if (name == null) {
                throw new NullPointerException("name must not be null");
            }
            this.name = name;
            this.direction = direction;
        }

        public String getName() {
            return this.name;
        }

        public Query.SortDirection getDirection() {
            return this.direction;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Property) {
                Property other = (Property)obj;
                return this.name.equals(other.name) && Objects.equals((Object)this.direction, (Object)other.direction);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + (this.direction == null ? 0 : this.direction.hashCode());
        }

        public String toString() {
            String string = this.name;
            String string2 = String.valueOf((Object)this.direction);
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
        }
    }

    public static enum IndexState {
        BUILDING,
        SERVING,
        DELETING,
        ERROR;

    }
}

