/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AggregateFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    CollectionFuture() {
    }

    @GoogleInternal
    @GwtIncompatible
    static final class MapFuture<K, V>
    extends CollectionFuture<V, Map<K, V>> {
        MapFuture(ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            this.init(new MapFutureRunningState(this, futures, allMustSucceed));
        }

        private final class MapFutureRunningState
        extends CollectionFutureRunningState {
            @Nullable
            ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures;

            MapFutureRunningState(MapFuture mapFuture, ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
                super(futures.values(), allMustSucceed);
                this.futures = futures;
            }

            public Map<K, V> combine(List<Optional<V>> values) {
                LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize(values.size());
                for (Pair entry : Iterables.pairUp(this.futures.keySet(), values)) {
                    if (entry.second == null) continue;
                    result.put(entry.first, ((Optional)entry.second).orNull());
                }
                return Collections.unmodifiableMap(result);
            }

            @Override
            void releaseResourcesAfterFailure() {
                super.releaseResourcesAfterFailure();
                this.futures = null;
            }
        }
    }

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            this.init(new ListFutureRunningState(this, futures, allMustSucceed));
        }

        private final class ListFutureRunningState
        extends CollectionFutureRunningState {
            ListFutureRunningState(ListFuture listFuture, ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
                super(futures, allMustSucceed);
            }

            public List<V> combine(List<Optional<V>> values) {
                ArrayList<Object> result = Lists.newArrayListWithCapacity(values.size());
                for (Optional element : values) {
                    result.add(element != null ? (Object)element.orNull() : null);
                }
                return Collections.unmodifiableList(result);
            }
        }
    }

    abstract class CollectionFutureRunningState
    extends AggregateFuture.RunningState {
        private List<Optional<V>> values;

        CollectionFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed, true);
            this.values = (List)((Object)(futures.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(futures.size())));
            for (int i = 0; i < futures.size(); ++i) {
                this.values.add(null);
            }
        }

        final void collectOneValue(boolean allMustSucceed, int index, @Nullable V returnValue) {
            List localValues = this.values;
            if (localValues != null) {
                localValues.set(index, Optional.fromNullable(returnValue));
            } else {
                Preconditions.checkState(allMustSucceed || CollectionFuture.this.isCancelled(), "Future was done before all dependencies completed");
            }
        }

        @Override
        final void handleAllCompleted() {
            List localValues = this.values;
            if (localValues != null) {
                CollectionFuture.this.set(this.combine(localValues));
            } else {
                Preconditions.checkState(CollectionFuture.this.isDone());
            }
        }

        @Override
        void releaseResourcesAfterFailure() {
            super.releaseResourcesAfterFailure();
            this.values = null;
        }

        abstract C combine(List<Optional<V>> var1);
    }
}

