/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.api.images.Composite;
import com.google.appengine.api.images.CompositeImpl;
import com.google.appengine.api.images.CompositeTransform;
import com.google.appengine.api.images.Crop;
import com.google.appengine.api.images.HorizontalFlip;
import com.google.appengine.api.images.IImagesServiceFactory;
import com.google.appengine.api.images.ImFeelingLucky;
import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.ImageImpl;
import com.google.appengine.api.images.ImagesService;
import com.google.appengine.api.images.ImagesServiceImpl;
import com.google.appengine.api.images.Resize;
import com.google.appengine.api.images.Rotate;
import com.google.appengine.api.images.Transform;
import com.google.appengine.api.images.VerticalFlip;
import java.util.Collection;

final class ImagesServiceFactoryImpl
implements IImagesServiceFactory {
    ImagesServiceFactoryImpl() {
    }

    @Override
    public ImagesService getImagesService() {
        return new ImagesServiceImpl();
    }

    @Override
    public Image makeImage(byte[] imageData) {
        return new ImageImpl(imageData);
    }

    @Override
    public Image makeImageFromBlob(BlobKey blobKey) {
        return new ImageImpl(blobKey);
    }

    @Override
    public Image makeImageFromFilename(String filename) {
        BlobKey blobKey = BlobstoreServiceFactory.getBlobstoreService().createGsBlobKey(filename);
        return new ImageImpl(blobKey);
    }

    @Override
    public Transform makeResize(int width, int height) {
        return new Resize(width, height, false, 0.0f, 0.0f);
    }

    @Override
    public Transform makeResize(int width, int height, boolean allowStretch) {
        return new Resize(width, height, allowStretch);
    }

    @Override
    public Transform makeResize(int width, int height, float cropOffsetX, float cropOffsetY) {
        return new Resize(width, height, true, cropOffsetX, cropOffsetY);
    }

    @Override
    public Transform makeResize(int width, int height, double cropOffsetX, double cropOffsetY) {
        return new Resize(width, height, true, (float)cropOffsetX, (float)cropOffsetY);
    }

    @Override
    public Transform makeCrop(float leftX, float topY, float rightX, float bottomY) {
        return new Crop(leftX, topY, rightX, bottomY);
    }

    @Override
    public Transform makeCrop(double leftX, double topY, double rightX, double bottomY) {
        return this.makeCrop((float)leftX, (float)topY, (float)rightX, (float)bottomY);
    }

    @Override
    public Transform makeVerticalFlip() {
        return new VerticalFlip();
    }

    @Override
    public Transform makeHorizontalFlip() {
        return new HorizontalFlip();
    }

    @Override
    public Transform makeRotate(int degrees) {
        return new Rotate(degrees);
    }

    @Override
    public Transform makeImFeelingLucky() {
        return new ImFeelingLucky();
    }

    @Override
    public CompositeTransform makeCompositeTransform(Collection<Transform> transforms) {
        return new CompositeTransform(transforms);
    }

    @Override
    public CompositeTransform makeCompositeTransform() {
        return new CompositeTransform();
    }

    @Override
    public Composite makeComposite(Image image, int xOffset, int yOffset, float opacity, Composite.Anchor anchor) {
        return new CompositeImpl(image, xOffset, yOffset, opacity, anchor);
    }
}

