/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientOutOfMemoryHandler;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.HazelcastClientFactory;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.impl.DefaultClientConnectionManagerFactory;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.util.EmptyStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class HazelcastClientManager {
    public static final HazelcastClientManager INSTANCE = new HazelcastClientManager();
    private final ConcurrentMap<String, HazelcastClientProxy> clients = new ConcurrentHashMap<String, HazelcastClientProxy>(5);

    private HazelcastClientManager() {
    }

    public static HazelcastInstance newHazelcastClient(HazelcastClientFactory hazelcastClientFactory) {
        return HazelcastClientManager.newHazelcastClient(new XmlClientConfigBuilder().build(), hazelcastClientFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstance newHazelcastClient(ClientConfig config, HazelcastClientFactory hazelcastClientFactory) {
        Object proxy;
        if (config == null) {
            config = new XmlClientConfigBuilder().build();
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HazelcastClient.class.getClassLoader());
            DefaultClientConnectionManagerFactory clientConnectionManagerFactory = new DefaultClientConnectionManagerFactory();
            Object client = hazelcastClientFactory.createHazelcastInstanceClient(config, clientConnectionManagerFactory);
            ((HazelcastClientInstanceImpl)client).start();
            OutOfMemoryErrorDispatcher.registerClient(client);
            proxy = hazelcastClientFactory.createProxy(client);
            if (HazelcastClientManager.INSTANCE.clients.putIfAbsent(((HazelcastClientInstanceImpl)client).getName(), (HazelcastClientProxy)proxy) != null) {
                throw new DuplicateInstanceNameException("HazelcastClientInstance with name '" + ((HazelcastClientInstanceImpl)client).getName() + "' already exists!");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return proxy;
    }

    public static HazelcastInstance getHazelcastClientByName(String instanceName) {
        return (HazelcastInstance)HazelcastClientManager.INSTANCE.clients.get(instanceName);
    }

    public static Collection<HazelcastInstance> getAllHazelcastClients() {
        Collection values = HazelcastClientManager.INSTANCE.clients.values();
        return Collections.unmodifiableCollection(new HashSet(values));
    }

    public static void shutdownAll() {
        for (HazelcastClientProxy proxy : HazelcastClientManager.INSTANCE.clients.values()) {
            HazelcastClientInstanceImpl client = proxy.client;
            if (client == null) continue;
            proxy.client = null;
            try {
                client.shutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
        OutOfMemoryErrorDispatcher.clearClients();
        HazelcastClientManager.INSTANCE.clients.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(HazelcastInstance instance) {
        if (instance instanceof HazelcastClientProxy) {
            HazelcastClientProxy proxy = (HazelcastClientProxy)instance;
            HazelcastClientInstanceImpl client = proxy.client;
            if (client == null) {
                return;
            }
            proxy.client = null;
            HazelcastClientManager.INSTANCE.clients.remove(client.getName());
            try {
                client.shutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            finally {
                OutOfMemoryErrorDispatcher.deregisterClient((HazelcastInstance)client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(String instanceName) {
        HazelcastClientProxy proxy = (HazelcastClientProxy)HazelcastClientManager.INSTANCE.clients.remove(instanceName);
        if (proxy == null) {
            return;
        }
        HazelcastClientInstanceImpl client = proxy.client;
        if (client == null) {
            return;
        }
        proxy.client = null;
        try {
            client.shutdown();
        }
        catch (Throwable ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
        finally {
            OutOfMemoryErrorDispatcher.deregisterClient((HazelcastInstance)client);
        }
    }

    public static void setOutOfMemoryHandler(OutOfMemoryHandler outOfMemoryHandler) {
        OutOfMemoryErrorDispatcher.setClientHandler((OutOfMemoryHandler)outOfMemoryHandler);
    }

    static {
        OutOfMemoryErrorDispatcher.setClientHandler((OutOfMemoryHandler)new ClientOutOfMemoryHandler());
    }
}

