/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.om.ArrayAA;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.om.ListAA;
import org.beetl.core.om.MapAA;
import org.beetl.core.om.MapEntryAA;
import org.beetl.core.om.ReflectBeanAA;

public class DefaultAAFactory {
    protected ListAA listAA = new ListAA();
    protected MapAA mapAA = new MapAA();
    protected ArrayAA arrayAA = new ArrayAA();
    protected MapEntryAA mapEntryAA = new MapEntryAA();
    protected ReflectBeanAA reflectBeanAA = new ReflectBeanAA();
    protected Map<Class, AttributeAccess> classAttrs = new ConcurrentHashMap<Class, AttributeAccess>();

    public DefaultAAFactory() {
        this.classAttrs.put(HashMap.class, this.mapAA);
        this.classAttrs.put(ConcurrentHashMap.class, this.mapAA);
        this.classAttrs.put(LinkedHashMap.class, this.mapAA);
        this.classAttrs.put(ArrayList.class, this.listAA);
        this.classAttrs.put(Map.Entry.class, this.mapEntryAA);
    }

    public AttributeAccess buildFiledAccessor(Class c) {
        AttributeAccess aa = this.classAttrs.get(c);
        if (aa != null) {
            return aa;
        }
        if (c.isArray()) {
            this.classAttrs.putIfAbsent(c, this.arrayAA);
            return this.arrayAA;
        }
        if (Map.class.isAssignableFrom(c)) {
            this.classAttrs.putIfAbsent(c, this.mapAA);
            return this.mapAA;
        }
        if (List.class.isAssignableFrom(c)) {
            this.classAttrs.putIfAbsent(c, this.listAA);
            return this.listAA;
        }
        if (Map.Entry.class.isAssignableFrom(c)) {
            this.classAttrs.putIfAbsent(c, this.mapEntryAA);
            return this.mapEntryAA;
        }
        aa = this.registerClass(c);
        return aa;
    }

    protected AttributeAccess registerClass(Class c) {
        this.classAttrs.put(c, this.reflectBeanAA);
        return this.reflectBeanAA;
    }

    public ListAA getListAA() {
        return this.listAA;
    }

    public void setListAA(ListAA listAA) {
        this.listAA = listAA;
    }
}

