/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.org.jline.utils;

import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.Size;
import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.impl.AbstractTerminal;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.AttributedString;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.AttributedStringBuilder;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.AttributedStyle;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.InfoCmp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Status {
    protected final AbstractTerminal terminal;
    protected final boolean supported;
    protected List<AttributedString> oldLines;
    protected List<AttributedString> linesToRestore;
    protected int rows;
    protected int columns;
    protected boolean force;
    protected boolean suspended;
    protected AttributedString borderString;
    protected int border;

    public void resize() {
        Size size = this.terminal.getSize();
        this.rows = size.getRows();
        this.columns = size.getColumns();
        this.force = true;
    }

    private void clearAll() {
        int b = this.border;
        this.border = 0;
        this.privateClear(this.oldLines.size() + b);
    }

    private void privateClear(int statusSize) {
        ArrayList<AttributedString> as = new ArrayList<AttributedString>();
        for (int i = 0; i < statusSize; ++i) {
            as.add(new AttributedString(""));
        }
        if (!as.isEmpty()) {
            this.update(as);
        }
    }

    public void update(List<AttributedString> lines) {
        int i;
        if (!this.supported) {
            return;
        }
        if (lines == null) {
            lines = Collections.emptyList();
        }
        if (this.suspended) {
            this.linesToRestore = new ArrayList<AttributedString>(lines);
            return;
        }
        if (lines.isEmpty()) {
            this.clearAll();
        }
        if (this.oldLines.equals(lines) && !this.force) {
            return;
        }
        int statusSize = lines.size() + (lines.size() == 0 ? 0 : this.border);
        int nb = statusSize - this.oldLines.size() - (this.oldLines.size() == 0 ? 0 : this.border);
        if (nb > 0) {
            for (i = 0; i < nb; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_down, new Object[0]);
            }
            for (i = 0; i < nb; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_up, new Object[0]);
            }
        }
        this.terminal.puts(InfoCmp.Capability.save_cursor, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - statusSize, 0);
        this.terminal.puts(InfoCmp.Capability.clr_eos, new Object[0]);
        if (this.border == 1 && lines.size() > 0) {
            this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - statusSize, 0);
            this.borderString.columnSubSequence(0, this.columns).print(this.terminal);
        }
        for (i = 0; i < lines.size(); ++i) {
            this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - lines.size() + i, 0);
            if (lines.get(i).length() > this.columns) {
                AttributedStringBuilder asb = new AttributedStringBuilder();
                asb.append(lines.get(i).substring(0, this.columns - 3)).append("...", new AttributedStyle(AttributedStyle.INVERSE));
                asb.toAttributedString().columnSubSequence(0, this.columns).print(this.terminal);
                continue;
            }
            lines.get(i).columnSubSequence(0, this.columns).print(this.terminal);
        }
        this.terminal.puts(InfoCmp.Capability.change_scroll_region, 0, this.rows - 1 - statusSize);
        this.terminal.puts(InfoCmp.Capability.restore_cursor, new Object[0]);
        this.terminal.flush();
        this.oldLines = new ArrayList<AttributedString>(lines);
        this.force = false;
    }
}

