/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.LinearSeq;
import coursierapi.shaded.scala.collection.LinearSeqIterator;
import coursierapi.shaded.scala.collection.SeqOps;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import java.util.NoSuchElementException;

public interface LinearSeqOps<A, CC extends LinearSeq<Object>, C extends LinearSeq<A> & LinearSeqOps<A, CC, C>>
extends SeqOps<A, CC, C> {
    public /* synthetic */ boolean scala$collection$LinearSeqOps$$super$sameElements(IterableOnce var1);

    @Override
    public boolean isEmpty();

    @Override
    public A head();

    public static /* synthetic */ Option headOption$(LinearSeqOps $this) {
        return $this.headOption();
    }

    @Override
    default public Option<A> headOption() {
        if (this.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some<A>(this.head());
    }

    public static /* synthetic */ Iterator iterator$(LinearSeqOps $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        if (this.knownSize() == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new LinearSeqIterator(this);
    }

    public static /* synthetic */ int length$(LinearSeqOps $this) {
        return $this.length();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public int length() {
        void var2_2;
        LinearSeq these = (LinearSeq)this.coll();
        int len = 0;
        while (these.nonEmpty()) {
            ++len;
            these = (LinearSeq)these.tail();
        }
        return (int)var2_2;
    }

    public static /* synthetic */ Object last$(LinearSeqOps $this) {
        return $this.last();
    }

    @Override
    default public A last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("LinearSeq.last");
        }
        LinearSeq these = (LinearSeq)this.coll();
        LinearSeq scout = (LinearSeq)this.tail();
        while (scout.nonEmpty()) {
            these = scout;
            scout = (LinearSeq)scout.tail();
        }
        return these.head();
    }

    public static /* synthetic */ int lengthCompare$(LinearSeqOps $this, int len) {
        return $this.lengthCompare(len);
    }

    @Override
    default public int lengthCompare(int len) {
        if (len < 0) {
            return 1;
        }
        return this.loop$1(0, (LinearSeq)this.coll(), len);
    }

    public static /* synthetic */ boolean isDefinedAt$(LinearSeqOps $this, int x) {
        return $this.isDefinedAt(x);
    }

    @Override
    default public boolean isDefinedAt(int x) {
        return x >= 0 && this.lengthCompare(x) > 0;
    }

    public static /* synthetic */ Object apply$(LinearSeqOps $this, int n) {
        return $this.apply(n);
    }

    @Override
    default public A apply(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException(((Object)n).toString());
        }
        LinearSeq skipped = (LinearSeq)this.drop(n);
        if (skipped.isEmpty()) {
            throw new IndexOutOfBoundsException(((Object)n).toString());
        }
        return skipped.head();
    }

    @Override
    default public <U> void foreach(Function1<A, U> f) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            f.apply(these.head());
            these = (LinearSeq)these.tail();
        }
    }

    public static /* synthetic */ boolean forall$(LinearSeqOps $this, Function1 p) {
        return $this.forall(p);
    }

    @Override
    default public boolean forall(Function1<A, Object> p) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            if (!BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return false;
            }
            these = (LinearSeq)these.tail();
        }
        return true;
    }

    public static /* synthetic */ boolean exists$(LinearSeqOps $this, Function1 p) {
        return $this.exists(p);
    }

    @Override
    default public boolean exists(Function1<A, Object> p) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return true;
            }
            these = (LinearSeq)these.tail();
        }
        return false;
    }

    public static /* synthetic */ boolean contains$(LinearSeqOps $this, Object elem) {
        return $this.contains(elem);
    }

    @Override
    default public <A1> boolean contains(A1 elem) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            if (BoxesRunTime.equals(these.head(), elem)) {
                return true;
            }
            these = (LinearSeq)these.tail();
        }
        return false;
    }

    @Override
    default public Option<A> find(Function1<A, Object> p) {
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return new Some<A>(these.head());
            }
            these = (LinearSeq)these.tail();
        }
        return None$.MODULE$;
    }

    public static /* synthetic */ Object foldLeft$(LinearSeqOps $this, Object z, Function2 op) {
        return $this.foldLeft(z, op);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public <B> B foldLeft(B z, Function2<B, A, B> op) {
        void var3_3;
        B acc = z;
        LinearSeq these = (LinearSeq)this.coll();
        while (!these.isEmpty()) {
            acc = op.apply(acc, these.head());
            these = (LinearSeq)these.tail();
        }
        return var3_3;
    }

    public static /* synthetic */ boolean sameElements$(LinearSeqOps $this, IterableOnce that) {
        return $this.sameElements(that);
    }

    @Override
    default public <B> boolean sameElements(IterableOnce<B> that) {
        boolean bl;
        if (that instanceof LinearSeq) {
            LinearSeq linearSeq = (LinearSeq)that;
            bl = this.linearSeqEq$1((LinearSeq)this.coll(), linearSeq);
        } else {
            bl = this.scala$collection$LinearSeqOps$$super$sameElements(that);
        }
        return bl;
    }

    public static /* synthetic */ int indexWhere$(LinearSeqOps $this, Function1 p, int from) {
        return $this.indexWhere(p, from);
    }

    @Override
    default public int indexWhere(Function1<A, Object> p, int from) {
        int max_y = 0;
        int i = Math.max(from, max_y);
        LinearSeq these = (LinearSeq)this.drop(from);
        while (these.nonEmpty()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(these.head()))) {
                return i;
            }
            ++i;
            these = (LinearSeq)these.tail();
        }
        return -1;
    }

    private int loop$1(int i, LinearSeq xs, int len$1) {
        while (true) {
            if (i == len$1) {
                if (xs.isEmpty()) {
                    return 0;
                }
                return 1;
            }
            if (xs.isEmpty()) {
                return -1;
            }
            xs = (LinearSeq)xs.tail();
            ++i;
        }
    }

    private boolean linearSeqEq$1(LinearSeq a, LinearSeq b) {
        block2: {
            while (a != b) {
                if (a.nonEmpty() && b.nonEmpty() && BoxesRunTime.equals(a.head(), b.head())) {
                    b = (LinearSeq)b.tail();
                    a = (LinearSeq)a.tail();
                    continue;
                }
                if (!(a.isEmpty() && b.isEmpty())) break block2;
            }
            return true;
        }
        return false;
    }
}

