/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.immutable;

import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.SeqOps;
import coursierapi.shaded.scala.collection.immutable.BitmapIndexedSetNode;
import coursierapi.shaded.scala.collection.immutable.SetNode;
import coursierapi.shaded.scala.collection.immutable.SetNode$;
import coursierapi.shaded.scala.collection.immutable.Vector;
import coursierapi.shaded.scala.collection.immutable.VectorBuilder;
import coursierapi.shaded.scala.collection.mutable.Builder;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;

public final class HashCollisionSetNode<A>
extends SetNode<A> {
    private final int originalHash;
    private final int hash;
    private Vector<A> content;

    public int originalHash() {
        return this.originalHash;
    }

    public int hash() {
        return this.hash;
    }

    public Vector<A> content() {
        return this.content;
    }

    public void content_$eq(Vector<A> x$1) {
        this.content = x$1;
    }

    @Override
    public boolean contains(A element, int originalHash, int hash, int shift) {
        if (this.hash() == hash) {
            Vector<A> vector = this.content();
            if (vector == null) {
                throw null;
            }
            if (SeqOps.contains$(vector, element)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public SetNode<A> updated(A element, int originalHash, int hash, int shift) {
        if (this.contains(element, originalHash, hash, shift)) {
            return this;
        }
        return new HashCollisionSetNode<A>(originalHash, hash, this.content().appended(element));
    }

    @Override
    public SetNode<A> removed(A element, int originalHash, int hash, int shift) {
        if (!this.contains(element, originalHash, hash, shift)) {
            return this;
        }
        Vector<A> vector = this.content();
        if (vector == null) {
            throw null;
        }
        Vector<A> filterNot_this = vector;
        boolean filterImpl_isFlipped = true;
        Builder filterImpl_b = filterNot_this.newSpecificBuilder();
        Iterator filterImpl_it = filterNot_this.iterator();
        while (filterImpl_it.hasNext()) {
            Object filterImpl_elem = filterImpl_it.next();
            if (HashCollisionSetNode.$anonfun$removed$1(element, filterImpl_elem) == filterImpl_isFlipped) continue;
            if (filterImpl_b == null) {
                throw null;
            }
            filterImpl_b.addOne(filterImpl_elem);
        }
        Object var10_7 = null;
        Object var11_8 = null;
        Object var12_9 = null;
        Object var6_5 = null;
        Vector updatedContent = (Vector)filterImpl_b.result();
        if (updatedContent == null) {
            throw null;
        }
        switch (updatedContent.length()) {
            case 1: {
                int maskFrom_shift = 0;
                int n = hash >>> maskFrom_shift & 0x1F;
                return new BitmapIndexedSetNode(1 << n, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{updatedContent.apply(0)}), ClassTag$.MODULE$.Any()), new int[]{originalHash}, 1, hash);
            }
        }
        return new HashCollisionSetNode<A>(originalHash, hash, updatedContent);
    }

    @Override
    public boolean hasNodes() {
        return false;
    }

    @Override
    public int nodeArity() {
        return 0;
    }

    @Override
    public SetNode<A> getNode(int index) {
        throw new IndexOutOfBoundsException("No sub-nodes present in hash-collision leaf node.");
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    @Override
    public int payloadArity() {
        return this.content().length();
    }

    @Override
    public A getPayload(int index) {
        return this.content().apply(index);
    }

    @Override
    public int getHash(int index) {
        return this.originalHash();
    }

    @Override
    public int size() {
        return this.content().length();
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        Iterator<A> iter = this.content().iterator();
        while (iter.hasNext()) {
            f.apply(iter.next());
        }
    }

    @Override
    public int cachedJavaKeySetHashCode() {
        return this.size() * this.hash();
    }

    @Override
    public SetNode<A> filterImpl(Function1<A, Object> pred, boolean flipped) {
        Vector<A> vector = this.content();
        if (vector == null) {
            throw null;
        }
        Vector<A> filterImpl_this = vector;
        Builder filterImpl_b = filterImpl_this.newSpecificBuilder();
        Iterator filterImpl_it = filterImpl_this.iterator();
        while (filterImpl_it.hasNext()) {
            Object filterImpl_elem = filterImpl_it.next();
            if (BoxesRunTime.unboxToBoolean(pred.apply(filterImpl_elem)) == flipped) continue;
            if (filterImpl_b == null) {
                throw null;
            }
            filterImpl_b.addOne(filterImpl_elem);
        }
        Object var7_4 = null;
        Object var8_5 = null;
        Object var9_6 = null;
        Object var5_3 = null;
        Vector newContent = (Vector)filterImpl_b.result();
        int newContentLength = newContent.length();
        if (newContentLength == 0) {
            return SetNode$.MODULE$.empty();
        }
        if (newContentLength == 1) {
            int n = this.hash() >>> 0 & 0x1F;
            return new BitmapIndexedSetNode(1 << n, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{newContent.head()}), ClassTag$.MODULE$.Any()), new int[]{this.originalHash()}, 1, this.hash());
        }
        if (newContent.length() == this.content().length()) {
            return this;
        }
        return new HashCollisionSetNode<A>(this.originalHash(), this.hash(), newContent);
    }

    @Override
    public SetNode<A> diff(SetNode<A> that, int shift) {
        boolean filterImpl_flipped = true;
        Vector<A> vector = this.content();
        if (vector == null) {
            throw null;
        }
        Vector<A> filterImpl_filterImpl_this = vector;
        Builder filterImpl_b = filterImpl_filterImpl_this.newSpecificBuilder();
        Iterator filterImpl_it = filterImpl_filterImpl_this.iterator();
        while (filterImpl_it.hasNext()) {
            Object filterImpl_elem = filterImpl_it.next();
            if (that.contains(filterImpl_elem, this.originalHash(), this.hash(), shift) == filterImpl_flipped) continue;
            if (filterImpl_b == null) {
                throw null;
            }
            filterImpl_b.addOne(filterImpl_elem);
        }
        Object var8_5 = null;
        Object var9_6 = null;
        Object var10_7 = null;
        Object var6_4 = null;
        Vector filterImpl_newContent = (Vector)filterImpl_b.result();
        int filterImpl_newContentLength = filterImpl_newContent.length();
        if (filterImpl_newContentLength == 0) {
            return SetNode$.MODULE$.empty();
        }
        if (filterImpl_newContentLength == 1) {
            int n = this.hash() >>> 0 & 0x1F;
            return new BitmapIndexedSetNode(1 << n, 0, (Object[])Array$.MODULE$.apply(ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{filterImpl_newContent.head()}), ClassTag$.MODULE$.Any()), new int[]{this.originalHash()}, 1, this.hash());
        }
        if (filterImpl_newContent.length() == this.content().length()) {
            return this;
        }
        return new HashCollisionSetNode<A>(this.originalHash(), this.hash(), filterImpl_newContent);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        void var6_5;
        if (!(that instanceof HashCollisionSetNode)) return false;
        HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)that;
        if (this == hashCollisionSetNode) return true;
        if (this.hash() != hashCollisionSetNode.hash()) return false;
        Vector<A> vector = this.content();
        if (vector == null) {
            throw null;
        }
        Vector<A> vector2 = hashCollisionSetNode.content();
        if (vector2 == null) {
            throw null;
        }
        if (vector.length() != vector2.length()) return false;
        Vector<A> vector3 = this.content();
        Vector<A> vector4 = hashCollisionSetNode.content();
        if (vector3 == null) {
            throw null;
        }
        Vector<A> forall_this = vector3;
        boolean forall_res = true;
        Iterator forall_it = forall_this.iterator();
        while (forall_res && forall_it.hasNext()) {
            Object a = forall_it.next();
            if (vector4 == null) {
                throw null;
            }
            forall_res = SeqOps.contains$(vector4, a);
        }
        Object var7_6 = null;
        Object var5_4 = null;
        if (var6_5 == false) return false;
        return true;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    @Override
    public HashCollisionSetNode<A> copy() {
        return new HashCollisionSetNode<A>(this.originalHash(), this.hash(), this.content());
    }

    @Override
    public SetNode<A> concat(SetNode<A> that, int shift) {
        HashCollisionSetNode<A> hashCollisionSetNode;
        if (that instanceof HashCollisionSetNode) {
            HashCollisionSetNode hashCollisionSetNode2 = (HashCollisionSetNode)that;
            if (hashCollisionSetNode2 == this) {
                hashCollisionSetNode = this;
            } else {
                VectorBuilder newContent = null;
                Iterator<A> iter = hashCollisionSetNode2.content().iterator();
                while (iter.hasNext()) {
                    A nextPayload = iter.next();
                    Vector<A> vector = this.content();
                    if (vector == null) {
                        throw null;
                    }
                    if (SeqOps.contains$(vector, nextPayload)) continue;
                    if (newContent == null) {
                        newContent = new VectorBuilder();
                        newContent.addAll((IterableOnce)this.content());
                    }
                    newContent.addOne((Object)nextPayload);
                }
                hashCollisionSetNode = newContent == null ? this : new HashCollisionSetNode<A>(this.originalHash(), this.hash(), newContent.result());
            }
        } else {
            if (that instanceof BitmapIndexedSetNode) {
                throw new UnsupportedOperationException("Cannot concatenate a HashCollisionSetNode with a BitmapIndexedSetNode");
            }
            throw new MatchError(that);
        }
        HashCollisionSetNode<A> hashCollisionSetNode3 = hashCollisionSetNode;
        return hashCollisionSetNode3;
    }

    @Override
    public void foreachWithHash(Function2<A, Object, BoxedUnit> f) {
        Iterator<A> iter = this.content().iterator();
        while (iter.hasNext()) {
            A next = iter.next();
            f.apply(next, this.originalHash());
        }
    }

    public static final /* synthetic */ boolean $anonfun$removed$1(Object element$1, Object element0) {
        return BoxesRunTime.equals(element0, element$1);
    }

    public HashCollisionSetNode(int originalHash, int hash, Vector<A> content) {
        this.originalHash = originalHash;
        this.hash = hash;
        this.content = content;
        Predef$.MODULE$.require(this.content().length() >= 2);
    }
}

