/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.spring.datasource;

import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingsphere.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class SpringShardingDataSource
extends ShardingDataSource {
    public SpringShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props) throws SQLException {
        super(SpringShardingDataSource.getRawDataSourceMap(dataSourceMap), new ShardingRule(SpringShardingDataSource.addMasterSlaveRuleConfigurations(dataSourceMap, shardingRuleConfig), dataSourceMap.keySet()), configMap, props);
    }

    private static Map<String, DataSource> getRawDataSourceMap(Map<String, DataSource> dataSourceMap) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            String dataSourceName = entry.getKey();
            DataSource dataSource = entry.getValue();
            if (dataSource instanceof MasterSlaveDataSource) {
                result.putAll(((MasterSlaveDataSource)dataSource).getAllDataSources());
                continue;
            }
            result.put(dataSourceName, dataSource);
        }
        return result;
    }

    private static ShardingRuleConfiguration addMasterSlaveRuleConfigurations(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig) {
        LinkedList<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs = new LinkedList<MasterSlaveRuleConfiguration>();
        for (DataSource each : dataSourceMap.values()) {
            if (!(each instanceof MasterSlaveDataSource)) continue;
            MasterSlaveRule masterSlaveRule = ((MasterSlaveDataSource)each).getMasterSlaveRule();
            masterSlaveRuleConfigs.add(new MasterSlaveRuleConfiguration(masterSlaveRule.getName(), masterSlaveRule.getMasterDataSourceName(), masterSlaveRule.getSlaveDataSourceNames(), masterSlaveRule.getLoadBalanceAlgorithm()));
        }
        shardingRuleConfig.setMasterSlaveRuleConfigs(masterSlaveRuleConfigs);
        return shardingRuleConfig;
    }
}

