/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.jdbc.spring.namespace.parser;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.shardingsphere.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmType;
import io.shardingsphere.jdbc.spring.datasource.SpringMasterSlaveDataSource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MasterSlaveDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringMasterSlaveDataSource.class);
        factory.addConstructorArgValue(this.parseDataSources(element));
        factory.addConstructorArgValue((Object)this.parseId(element));
        factory.addConstructorArgValue((Object)this.parseMasterDataSourceRef(element));
        factory.addConstructorArgValue(this.parseSlaveDataSourcesRef(element));
        String strategyRef = this.parseStrategyRef(element);
        if (!Strings.isNullOrEmpty((String)strategyRef)) {
            factory.addConstructorArgReference(strategyRef);
        } else {
            factory.addConstructorArgValue((Object)this.parseStrategyType(element));
        }
        factory.addConstructorArgValue((Object)this.parseConfigMap(element, parserContext, (BeanDefinition)factory.getBeanDefinition()));
        return factory.getBeanDefinition();
    }

    private Map<String, RuntimeBeanReference> parseDataSources(Element element) {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("slave-data-source-names"));
        ManagedMap result = new ManagedMap(slaveDataSources.size());
        for (String each : slaveDataSources) {
            result.put(each, new RuntimeBeanReference(each));
        }
        String masterDataSourceName = this.parseMasterDataSourceRef(element);
        result.put(masterDataSourceName, new RuntimeBeanReference(masterDataSourceName));
        return result;
    }

    private String parseId(Element element) {
        return element.getAttribute("id");
    }

    private String parseMasterDataSourceRef(Element element) {
        return element.getAttribute("master-data-source-name");
    }

    private Collection<String> parseSlaveDataSourcesRef(Element element) {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("slave-data-source-names"));
        ManagedList result = new ManagedList(slaveDataSources.size());
        result.addAll(slaveDataSources);
        return result;
    }

    private String parseStrategyRef(Element element) {
        return element.getAttribute("strategy-ref");
    }

    private MasterSlaveLoadBalanceAlgorithmType parseStrategyType(Element element) {
        String result = element.getAttribute("strategy-type");
        return Strings.isNullOrEmpty((String)result) ? MasterSlaveLoadBalanceAlgorithmType.getDefaultAlgorithmType() : MasterSlaveLoadBalanceAlgorithmType.valueOf((String)result);
    }

    private Map parseConfigMap(Element element, ParserContext parserContext, BeanDefinition beanDefinition) {
        Element dataElement = DomUtils.getChildElementByTagName((Element)element, (String)"config-map");
        return null == dataElement ? Collections.emptyMap() : parserContext.getDelegate().parseMapElement(dataElement, beanDefinition);
    }
}

