/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lingshou;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ApiCallback;
import com.tencent.ApiClient;
import com.tencent.ApiException;
import com.tencent.ApiResponse;
import com.tencent.Configuration;
import com.tencent.Pair;
import com.tencent.ProgressRequestBody;
import com.tencent.ProgressResponseBody;
import com.tencent.lingshou.model.BaseResponse;
import com.tencent.lingshou.model.CreateOrderRequest;
import com.tencent.lingshou.model.CreateOrderResponse;
import com.tencent.lingshou.model.SalesinfoAddRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SalesinfoApi {
    private ApiClient apiClient;

    private SalesinfoApi(SalesinfoApiBuilder builder) {
        this.apiClient = Configuration.getDefaultApiClient(builder.appId, builder.appSercet, null);
        this.apiClient.setBasePath(builder.baseUrl);
    }

    public SalesinfoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addSalesinfoCall(SalesinfoAddRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SalesinfoAddRequest localVarPostBody = body;
        String localVarPath = "/salesinfo/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addSalesinfoValidateBeforeCall(SalesinfoAddRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addSalesinfo(Async)");
        }
        Call call = this.addSalesinfoCall(body, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse addSalesinfo(SalesinfoAddRequest body) throws ApiException {
        ApiResponse<BaseResponse> resp = this.addSalesinfoWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> addSalesinfoWithHttpInfo(SalesinfoAddRequest body) throws ApiException {
        Call call = this.addSalesinfoValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addSalesinfoAsync(SalesinfoAddRequest body, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addSalesinfoValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSalesinfoDataSourceCall(CreateOrderRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateOrderRequest localVarPostBody = body;
        String localVarPath = "/salesinfo/create_salesinfo_data_source";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSalesinfoDataSourceValidateBeforeCall(CreateOrderRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSalesinfoDataSource(Async)");
        }
        Call call = this.createSalesinfoDataSourceCall(body, progressListener, progressRequestListener);
        return call;
    }

    public CreateOrderResponse createSalesinfoDataSource(CreateOrderRequest body) throws ApiException {
        ApiResponse<CreateOrderResponse> resp = this.createSalesinfoDataSourceWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<CreateOrderResponse> createSalesinfoDataSourceWithHttpInfo(CreateOrderRequest body) throws ApiException {
        Call call = this.createSalesinfoDataSourceValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSalesinfoDataSourceAsync(CreateOrderRequest body, final ApiCallback<CreateOrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSalesinfoDataSourceValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public static class SalesinfoApiBuilder {
        private String appId;
        private String appSercet;
        private String baseUrl;

        public SalesinfoApiBuilder(String appId, String appSercet, String baseUrl) {
            this.appId = appId;
            this.appSercet = appSercet;
            this.baseUrl = baseUrl;
        }

        public SalesinfoApi build() {
            return new SalesinfoApi(this);
        }
    }
}

