/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lingshou;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ApiCallback;
import com.tencent.ApiClient;
import com.tencent.ApiException;
import com.tencent.ApiResponse;
import com.tencent.Configuration;
import com.tencent.Pair;
import com.tencent.ProgressRequestBody;
import com.tencent.ProgressResponseBody;
import com.tencent.lingshou.model.BaseResponse;
import com.tencent.lingshou.model.CreateOrderRequest;
import com.tencent.lingshou.model.CreateOrderResponse;
import com.tencent.lingshou.model.SpusAddRequest;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SpuApi {
    private ApiClient apiClient;

    private SpuApi(SpuApiBuilder builder) {
        this.apiClient = Configuration.getDefaultApiClient(builder.appId, builder.appSercet, null);
        this.apiClient.setBasePath(builder.baseUrl);
    }

    public SpuApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addSpusCall(SpusAddRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SpusAddRequest localVarPostBody = body;
        String localVarPath = "/spus/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addSpusValidateBeforeCall(SpusAddRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addSpus(Async)");
        }
        Call call = this.addSpusCall(body, progressListener, progressRequestListener);
        return call;
    }

    public BaseResponse addSpus(SpusAddRequest body) throws ApiException {
        ApiResponse<BaseResponse> resp = this.addSpusWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<BaseResponse> addSpusWithHttpInfo(SpusAddRequest body) throws ApiException {
        Call call = this.addSpusValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addSpusAsync(SpusAddRequest body, final ApiCallback<BaseResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addSpusValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createSpusDataSourceCall(CreateOrderRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateOrderRequest localVarPostBody = body;
        String localVarPath = "/spus/create_spus_data_source";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSpusDataSourceValidateBeforeCall(CreateOrderRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createSpusDataSource(Async)");
        }
        Call call = this.createSpusDataSourceCall(body, progressListener, progressRequestListener);
        return call;
    }

    public CreateOrderResponse createSpusDataSource(CreateOrderRequest body) throws ApiException {
        ApiResponse<CreateOrderResponse> resp = this.createSpusDataSourceWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<CreateOrderResponse> createSpusDataSourceWithHttpInfo(CreateOrderRequest body) throws ApiException {
        Call call = this.createSpusDataSourceValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSpusDataSourceAsync(CreateOrderRequest body, final ApiCallback<CreateOrderResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSpusDataSourceValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateOrderResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public static class SpuApiBuilder {
        private String appId;
        private String appSercet;
        private String baseUrl;

        public SpuApiBuilder(String appId, String appSercet, String baseUrl) {
            this.appId = appId;
            this.appSercet = appSercet;
            this.baseUrl = baseUrl;
        }

        public SpuApi build() {
            return new SpuApi(this);
        }
    }
}

