/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.diablo.client;

import com.google.common.base.Throwables;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import me.hao0.diablo.client.AbstractDiabloClient;
import me.hao0.diablo.client.exception.Server503Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiabloWorker {
    private static final Logger log = LoggerFactory.getLogger(DiabloWorker.class);
    private ScheduledExecutorService executor;
    private AbstractDiabloClient client;

    DiabloWorker(AbstractDiabloClient client) {
        this.client = client;
    }

    public void start() {
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("DIABLO-CONFIG-CHECK-WORKER");
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        DiabloWorker.this.client.pullingConfigs();
                    }
                    catch (Server503Exception e) {
                        log.warn("all servers are unavailable, wait longer until servers are started");
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception e) {
                    log.error("failed to pulling updated config, cause: {}", (Object)Throwables.getStackTraceAsString((Throwable)e));
                }
            }
        }, 1L, 1L, TimeUnit.MILLISECONDS);
    }
}

