/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.component;

import java.util.HashSet;
import java.util.Set;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.component.Attribute;
import net.contextfw.web.application.component.Buildable;
import net.contextfw.web.application.component.DOMBuilder;
import net.contextfw.web.application.internal.component.ComponentBuilder;

@Buildable
public abstract class Component {
    private final Set<String> partialUpdates = new HashSet<String>();
    private String partialUpdateName;
    private RefreshMode refreshMode = RefreshMode.NONE;
    private Component parent = null;
    private Set<Component> children = null;
    private Set<Component> waitingToRegister = null;
    private boolean enabled = true;
    @Attribute
    private String id;

    public void setId(String id) {
        if (this.id != null) {
            throw new WebApplicationException("Component id can be set only once");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public <T extends Component> T registerChild(T el) {
        if (this.children == null) {
            this.children = new HashSet<Component>();
            this.waitingToRegister = new HashSet<Component>();
        }
        this.children.add(el);
        el.parent = this;
        if (this.bubbleRegisterUp(el)) {
            super.registerChildren();
        } else {
            this.waitingToRegister.add(el);
        }
        return el;
    }

    private void registerChildren() {
        if (this.waitingToRegister != null) {
            for (Component comp : this.waitingToRegister) {
                this.registerChild(comp);
            }
            this.waitingToRegister.clear();
        }
    }

    protected boolean bubbleRegisterUp(Component el) {
        if (this.parent != null) {
            return this.parent.bubbleRegisterUp(el);
        }
        return false;
    }

    protected void bubbleUnregisterUp(Component el) {
        if (this.parent != null) {
            this.parent.bubbleUnregisterUp(el);
        }
    }

    public void detach() {
        if (this.parent != null) {
            this.parent.unregisterChild(this);
        }
    }

    public void unregisterChild(Component el) {
        if (this.children != null) {
            this.children.remove(el);
            this.bubbleUnregisterUp(el);
            el.parent = null;
        }
    }

    public void refresh() {
        this.refresh(RefreshMode.UPDATE);
    }

    private void refresh(RefreshMode mode) {
        if (this.id != null) {
            this.refreshMode = mode;
            Component p = this.parent;
            while (p != null) {
                if (p.refreshMode == RefreshMode.NONE) {
                    p.refreshMode = RefreshMode.PASS;
                    p = p.parent;
                    continue;
                }
                p = null;
            }
        }
    }

    public final void buildComponentUpdate(DOMBuilder domBuilder, ComponentBuilder builder) {
        if (this.refreshMode == RefreshMode.UPDATE) {
            builder.buildUpdate(domBuilder, this, "update");
        } else if (this.refreshMode == RefreshMode.PARTIAL_UPDATE) {
            builder.buildPartialUpdate(domBuilder, this, this.partialUpdateName, this.partialUpdates);
        }
        if ((this.refreshMode == RefreshMode.PASS || this.refreshMode == RefreshMode.PARTIAL_UPDATE) && this.children != null) {
            for (Component child : this.children) {
                child.buildComponentUpdate(domBuilder, builder);
            }
        }
        this.clearCascadedUpdate();
    }

    public void partialRefresh(String buildName, String ... updates) {
        if (this.partialUpdates != null && this.refreshMode != RefreshMode.UPDATE) {
            this.partialUpdateName = buildName;
            for (String partialUpdate : updates) {
                this.partialUpdates.add(partialUpdate);
            }
            this.partialUpdates.add("id");
            this.refresh(RefreshMode.PARTIAL_UPDATE);
        }
    }

    public void clearCascadedUpdate() {
        if (this.refreshMode == RefreshMode.NONE) {
            return;
        }
        this.refreshMode = RefreshMode.NONE;
        if (this.children != null) {
            for (Component child : this.children) {
                child.clearCascadedUpdate();
            }
        }
        this.partialUpdates.clear();
        this.partialUpdateName = null;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static enum RefreshMode {
        NONE,
        PASS,
        UPDATE,
        PARTIAL_UPDATE;

    }
}

