/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.internal.ComponentUpdateHandler;
import net.contextfw.web.application.internal.util.ClassScanner;
import net.contextfw.web.application.lifecycle.LifecycleListener;

@Singleton
public class ComponentUpdateHandlerFactory {
    private Gson gson;
    private final LifecycleListener listener;

    @Inject
    public ComponentUpdateHandlerFactory(Gson gson, LifecycleListener listener) {
        this.gson = gson;
        this.listener = listener;
    }

    public ComponentUpdateHandler createHandler(Class<? extends Component> elClass, String methodName) {
        Method method = ClassScanner.findMethodForName(elClass, methodName);
        if (method != null) {
            return new ComponentUpdateHandler(ComponentUpdateHandler.getKey(elClass, methodName), method, this.gson, this.listener);
        }
        return null;
    }
}

