/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v1;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.JournalTransaction;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v1.BaseDataStreamMarshaller;

public class JournalTransactionMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 54;
    }

    @Override
    public DataStructure createObject() {
        return new JournalTransaction();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        JournalTransaction info2 = (JournalTransaction)o;
        info2.setTransactionId((TransactionId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setType(dataIn.readByte());
        info2.setWasPrepared(bs.readBoolean());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        JournalTransaction info2 = (JournalTransaction)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        bs.writeBoolean(info2.getWasPrepared());
        return (rc += this.tightMarshalNestedObject1(wireFormat, info2.getTransactionId(), bs)) + 1;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        JournalTransaction info2 = (JournalTransaction)o;
        this.tightMarshalNestedObject2(wireFormat, info2.getTransactionId(), dataOut, bs);
        dataOut.writeByte(info2.getType());
        bs.readBoolean();
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        JournalTransaction info2 = (JournalTransaction)o;
        info2.setTransactionId((TransactionId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setType(dataIn.readByte());
        info2.setWasPrepared(dataIn.readBoolean());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        JournalTransaction info2 = (JournalTransaction)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getTransactionId(), dataOut);
        dataOut.writeByte(info2.getType());
        dataOut.writeBoolean(info2.getWasPrepared());
    }
}

