/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

public class AlterTableSchemaOperation
extends AlterTableOperation {
    private final CatalogTable catalogTable;

    public AlterTableSchemaOperation(ObjectIdentifier tableIdentifier, CatalogTable catalogTable, boolean ignoreIfNotExists) {
        super(tableIdentifier, ignoreIfNotExists);
        this.catalogTable = catalogTable;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER TABLE %s%s SET SCHEMA %s", this.ignoreIfTableNotExists ? "IF EXISTS " : "", this.tableIdentifier.asSummaryString(), this.catalogTable.getUnresolvedSchema().toString());
    }
}

