/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.DeadlineTracker;
import org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.kudu.client.IPCUtil;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.RpcTraceFrame;
import org.apache.kudu.client.Statistics;
import org.apache.kudu.client.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.client.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.client.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.kudu.client.shaded.com.google.protobuf.GeneratedMessage;
import org.apache.kudu.client.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.kudu.util.Pair;
import org.apache.kudu.util.Slice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class KuduRpc<R> {
    @VisibleForTesting
    public static final int MAX_TRACES_SIZE = 100;
    protected static final String MASTER_SERVICE_NAME = "kudu.master.MasterService";
    protected static final String TABLET_SERVER_SERVICE_NAME = "kudu.tserver.TabletServerService";
    private static final Logger LOG = LoggerFactory.getLogger(KuduRpc.class);
    private final List<RpcTraceFrame> traces = Collections.synchronizedList(new ArrayList());
    private KuduRpc<?> parentRpc;
    private Deferred<R> deferred;
    private RemoteTablet tablet;
    final KuduTable table;
    final DeadlineTracker deadlineTracker;
    protected long propagatedTimestamp = -1L;
    protected ExternalConsistencyMode externalConsistencyMode = ExternalConsistencyMode.CLIENT_PROPAGATED;
    byte attempt;
    long sequenceId = -1L;
    static final long MAX_BYTE_ARRAY_MASK = -268435456L;

    byte[] partitionKey() {
        return null;
    }

    KuduRpc(KuduTable table) {
        this.table = table;
        this.deadlineTracker = new DeadlineTracker();
    }

    abstract ChannelBuffer serialize(Message var1);

    abstract String serviceName();

    abstract String method();

    Collection<Integer> getRequiredFeatures() {
        return ImmutableList.of();
    }

    abstract Pair<R, Object> deserialize(CallResponse var1, String var2) throws KuduException;

    void updateStatistics(Statistics statistics, R response) {
    }

    public void setExternalConsistencyMode(ExternalConsistencyMode externalConsistencyMode) {
        this.externalConsistencyMode = externalConsistencyMode;
    }

    public ExternalConsistencyMode getExternalConsistencyMode() {
        return this.externalConsistencyMode;
    }

    public void setPropagatedTimestamp(long propagatedTimestamp) {
        this.propagatedTimestamp = propagatedTimestamp;
    }

    private void handleCallback(Object result) {
        Deferred<R> d = this.deferred;
        if (d == null) {
            return;
        }
        this.deferred = null;
        this.attempt = 0;
        if (this.isRequestTracked()) {
            this.table.getAsyncClient().getRequestTracker().rpcCompleted(this.sequenceId);
            this.sequenceId = -1L;
        }
        this.deadlineTracker.reset();
        this.traces.clear();
        this.parentRpc = null;
        d.callback(result);
    }

    void addTrace(RpcTraceFrame rpcTraceFrame) {
        if (this.parentRpc != null) {
            this.parentRpc.addTrace(rpcTraceFrame);
        }
        if (this.traces.size() == 100) {
            this.traces.add(new RpcTraceFrame.RpcTraceFrameBuilder(this.method(), RpcTraceFrame.Action.TRACE_TRUNCATED).build());
        } else if (this.traces.size() < 100) {
            this.traces.add(rpcTraceFrame);
        }
    }

    void setParentRpc(KuduRpc<?> parentRpc) {
        assert (this.parentRpc == null);
        assert (this.parentRpc != this);
        this.parentRpc = parentRpc;
    }

    final void callback(R result) {
        this.handleCallback(result);
    }

    final void errback(Exception e) {
        this.handleCallback(e);
    }

    final Deferred<R> getDeferred() {
        if (this.deferred == null) {
            this.deferred = new Deferred();
        }
        return this.deferred;
    }

    RemoteTablet getTablet() {
        return this.tablet;
    }

    void setTablet(RemoteTablet tablet) {
        this.tablet = tablet;
    }

    public KuduTable getTable() {
        return this.table;
    }

    void setTimeoutMillis(long timeout) {
        this.deadlineTracker.setDeadline(timeout);
    }

    boolean isRequestTracked() {
        return false;
    }

    long getSequenceId() {
        return this.sequenceId;
    }

    ReplicaSelection getReplicaSelection() {
        return ReplicaSelection.LEADER_ONLY;
    }

    List<RpcTraceFrame> getImmutableTraces() {
        return ImmutableList.copyOf(this.traces);
    }

    void setSequenceId(long sequenceId) {
        assert (this.sequenceId == -1L);
        this.sequenceId = sequenceId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("KuduRpc(method=");
        buf.append(this.method());
        buf.append(", tablet=");
        if (this.tablet == null) {
            buf.append("null");
        } else {
            buf.append(this.tablet.getTabletId());
        }
        buf.append(", attempt=").append(this.attempt);
        buf.append(", ").append(this.deadlineTracker);
        buf.append(", ").append(RpcTraceFrame.getHumanReadableStringForTraces(this.traces));
        if (LOG.isDebugEnabled()) {
            buf.append(", ").append(this.deferred);
        }
        buf.append(')');
        return buf.toString();
    }

    static void readProtobuf(Slice slice, GeneratedMessage.Builder<?> builder) {
        int length = slice.length();
        byte[] payload = slice.getRawArray();
        int offset = slice.getRawOffset();
        try {
            builder.mergeFrom(payload, offset, length);
            if (!builder.isInitialized()) {
                throw new RuntimeException("Could not deserialize the response, incompatible RPC? Error is: " + builder.getInitializationErrorString());
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Invalid RPC response: length=" + length, e);
        }
    }

    static ChannelBuffer toChannelBuffer(Message header, Message pb) {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, pb);
        byte[] buf = new byte[totalSize + 4];
        ChannelBuffer chanBuf = ChannelBuffers.wrappedBuffer(buf);
        chanBuf.clear();
        chanBuf.writeInt(totalSize);
        CodedOutputStream out = CodedOutputStream.newInstance(buf, 4, totalSize);
        try {
            out.writeRawVarint32(header.getSerializedSize());
            header.writeTo(out);
            out.writeRawVarint32(pb.getSerializedSize());
            pb.writeTo(out);
            out.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize the following message " + pb);
        }
        chanBuf.writerIndex(buf.length);
        return chanBuf;
    }

    static void checkArrayLength(ChannelBuffer buf, long length) {
        if ((length & 0xFFFFFFFFF0000000L) != 0L) {
            if (length < 0L) {
                throw new IllegalArgumentException("Read negative byte array length: " + length + " in buf=" + buf);
            }
            throw new IllegalArgumentException("Read byte array length that's too large: " + length + " > " + 0xFFFFFFFL + " in buf=" + buf);
        }
    }
}

