/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.PingResponse;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class PingRequest
extends KuduRpc<PingResponse> {
    private final String serviceName;

    static PingRequest makeMasterPingRequest() {
        return new PingRequest("kudu.master.MasterService");
    }

    static PingRequest makeTabletServerPingRequest() {
        return new PingRequest("kudu.tserver.TabletServerService");
    }

    private PingRequest(String serviceName) {
        super(null);
        this.serviceName = serviceName;
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        Master.PingRequestPB.Builder builder = Master.PingRequestPB.newBuilder();
        return PingRequest.toChannelBuffer(header, builder.build());
    }

    @Override
    String serviceName() {
        return this.serviceName;
    }

    @Override
    String method() {
        return "Ping";
    }

    @Override
    Pair<PingResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.PingResponsePB.Builder respBuilder = Master.PingResponsePB.newBuilder();
        PingRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        PingResponse response = new PingResponse(this.deadlineTracker.getElapsedMillis(), tsUUID);
        return new Pair<PingResponse, Object>(response, null);
    }
}

