/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.booterclient.DefaultForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.Platform;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ModularClasspath;
import org.apache.maven.surefire.booter.ModularClasspathConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

public class ModularClasspathForkConfiguration
extends DefaultForkConfiguration {
    public ModularClasspathForkConfiguration(@Nonnull Classpath bootClasspath, @Nonnull File tempDirectory, @Nullable String debugLine, @Nonnull File workingDirectory, @Nonnull Properties modelProperties, @Nullable String argLine, @Nonnull Map<String, String> environmentVariables, boolean debug, @Nonnegative int forkCount, boolean reuseForks, @Nonnull Platform pluginPlatform, @Nonnull ConsoleLogger log) {
        super(bootClasspath, tempDirectory, debugLine, workingDirectory, modelProperties, argLine, environmentVariables, debug, forkCount, reuseForks, pluginPlatform, log);
    }

    @Override
    protected void resolveClasspath(@Nonnull OutputStreamFlushableCommandline cli, @Nonnull String startClass, @Nonnull StartupConfiguration config, @Nonnull File dumpLogDirectory) throws SurefireBooterForkException {
        try {
            AbstractPathConfiguration pathConfig = config.getClasspathConfiguration();
            ModularClasspathConfiguration modularClasspathConfiguration = (ModularClasspathConfiguration)pathConfig.toRealPath(ModularClasspathConfiguration.class);
            ModularClasspath modularClasspath = modularClasspathConfiguration.getModularClasspath();
            File descriptor = modularClasspath.getModuleDescriptor();
            List modulePath = modularClasspath.getModulePath();
            Collection packages = modularClasspath.getPackages();
            File patchFile = modularClasspath.getPatchFile();
            List<String> classpath = this.toCompleteClasspath(config);
            File argsFile = this.createArgsFile(descriptor, modulePath, classpath, packages, patchFile, startClass);
            cli.createArg().setValue("@" + SurefireHelper.escapeToPlatformPath(argsFile.getAbsolutePath()));
        }
        catch (IOException e) {
            String error = "Error creating args file";
            InPluginProcessDumpSingleton.getSingleton().dumpException(e, error, dumpLogDirectory);
            throw new SurefireBooterForkException(error, (Throwable)e);
        }
    }

    @Nonnull
    File createArgsFile(@Nonnull File moduleDescriptor, @Nonnull List<String> modulePath, @Nonnull List<String> classPath, @Nonnull Collection<String> packages, @Nonnull File patchFile, @Nonnull String startClassName) throws IOException {
        File surefireArgs = File.createTempFile("surefireargs", "", this.getTempDirectory());
        if (this.isDebug()) {
            this.getLogger().debug("Path to args file: " + surefireArgs.getCanonicalPath());
        } else {
            surefireArgs.deleteOnExit();
        }
        try (FileWriter io = new FileWriter(surefireArgs);){
            Iterator<String> it;
            StringBuilder args = new StringBuilder(65536);
            if (!modulePath.isEmpty()) {
                args.append("--module-path").append(org.apache.maven.surefire.util.internal.StringUtils.NL).append('\"');
                it = modulePath.iterator();
                while (it.hasNext()) {
                    args.append(StringUtils.replace(it.next(), "\\", "\\\\"));
                    if (!it.hasNext()) continue;
                    args.append(File.pathSeparatorChar);
                }
                args.append('\"').append(org.apache.maven.surefire.util.internal.StringUtils.NL);
            }
            if (!classPath.isEmpty()) {
                args.append("--class-path").append(org.apache.maven.surefire.util.internal.StringUtils.NL).append('\"');
                it = classPath.iterator();
                while (it.hasNext()) {
                    args.append(StringUtils.replace(it.next(), "\\", "\\\\"));
                    if (!it.hasNext()) continue;
                    args.append(File.pathSeparatorChar);
                }
                args.append('\"').append(org.apache.maven.surefire.util.internal.StringUtils.NL);
            }
            String moduleName = this.toModuleName(moduleDescriptor);
            args.append("--patch-module").append(org.apache.maven.surefire.util.internal.StringUtils.NL).append(moduleName).append('=').append('\"').append(StringUtils.replace(patchFile.getPath(), "\\", "\\\\")).append('\"').append(org.apache.maven.surefire.util.internal.StringUtils.NL);
            for (String pkg : packages) {
                args.append("--add-exports").append(org.apache.maven.surefire.util.internal.StringUtils.NL).append(moduleName).append('/').append(pkg).append('=').append("ALL-UNNAMED").append(org.apache.maven.surefire.util.internal.StringUtils.NL);
            }
            args.append("--add-modules").append(org.apache.maven.surefire.util.internal.StringUtils.NL).append(moduleName).append(org.apache.maven.surefire.util.internal.StringUtils.NL);
            args.append("--add-reads").append(org.apache.maven.surefire.util.internal.StringUtils.NL).append(moduleName).append('=').append("ALL-UNNAMED").append(org.apache.maven.surefire.util.internal.StringUtils.NL);
            args.append(startClassName);
            String argsFileContent = args.toString();
            if (this.isDebug()) {
                this.getLogger().debug("args file content:" + org.apache.maven.surefire.util.internal.StringUtils.NL + argsFileContent);
            }
            io.write(argsFileContent);
            File file = surefireArgs;
            return file;
        }
    }

    @Nonnull
    String toModuleName(@Nonnull File moduleDescriptor) throws IOException {
        if (!moduleDescriptor.isFile()) {
            throw new IOException("No such Jigsaw module-descriptor exists " + moduleDescriptor.getAbsolutePath());
        }
        final StringBuilder sb = new StringBuilder();
        new ClassReader((InputStream)new FileInputStream(moduleDescriptor)).accept(new ClassVisitor(458752){

            public ModuleVisitor visitModule(String name, int access, String version) {
                sb.setLength(0);
                sb.append(name);
                return super.visitModule(name, access, version);
            }
        }, 0);
        return sb.toString();
    }
}

