/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.metadata.ColumnsMetadata;

public class ColumnsImpl
implements Columns {
    protected ColumnsMetadata columnsMetadata;
    protected List<Column> columns;

    public ColumnsImpl(ColumnsMetadata columnsMetadata, List<Column> columns) {
        Validate.notNull((Object)columnsMetadata, (String)"Paraemter 'columnsMetadata' is null!");
        Validate.notEmpty(columns, (String)"Paraemter 'columns' is empty!");
        this.columnsMetadata = columnsMetadata;
        this.columns = columns;
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public ColumnsMetadata getColumnsMetadata() {
        return this.columnsMetadata;
    }

    @Override
    public Object[] getValue() {
        Object[] values = new Object[this.columns.size()];
        int i = 0;
        for (Column column : this.columns) {
            values[i++] = column.getValue();
        }
        return values;
    }

    @Override
    public void operate(EntityMap entityMap) {
        for (Column column : this.columns) {
            column.operate(entityMap);
        }
    }

    @Override
    public void clear() {
        for (Column column : this.columns) {
            column.clear();
        }
    }
}

