/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.MoqlGrammarException;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.Cache;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.core.RecordSetMetadata;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.cache.CacheImpl;
import org.datayoo.moql.metadata.CacheMetadata;
import org.datayoo.moql.operand.function.AggregationFunction;

public class ColumnsRecordSetOperator
implements RecordSetOperator {
    protected Cache<ColumnRecord, Object[]> cache;
    protected Columns columns;
    protected boolean distinct = false;
    protected boolean aggregation = false;
    protected Date start = new Date();

    public ColumnsRecordSetOperator(CacheMetadata cacheMetadata, Columns columns) throws MoqlGrammarException {
        Validate.notNull((Object)cacheMetadata, (String)"Parameter 'cacheMetadata' is null!");
        Validate.notNull((Object)columns, (String)"Parameter 'columns' is null!");
        this.cache = new CacheImpl<ColumnRecord, Object[]>(cacheMetadata);
        this.columns = columns;
        this.distinct = columns.getColumnsMetadata().isDistinct();
        this.checkColumns();
    }

    protected void checkColumns() throws MoqlGrammarException {
        boolean hasNonAggregationFunction = false;
        boolean hasAggregationFunction = false;
        for (Column column : this.columns.getColumns()) {
            if (column.getOperand() instanceof AggregationFunction) {
                hasAggregationFunction = true;
                continue;
            }
            hasNonAggregationFunction = true;
        }
        if (hasNonAggregationFunction && hasAggregationFunction) {
            throw new MoqlGrammarException("The select clause without group clause!");
        }
        if (hasAggregationFunction) {
            this.aggregation = true;
        }
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public Columns getColumns() {
        return this.columns;
    }

    @Override
    public RecordSet getValue() {
        RecordSetDefinition recordSetDefinition = this.createRecordSetDefinition();
        if (!this.aggregation) {
            return new RecordSetImpl(recordSetDefinition, this.start, new Date(), this.cache.values());
        }
        Object[] record = (Object[])this.columns.getValue();
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        records.add(record);
        return new RecordSetImpl(recordSetDefinition, this.start, new Date(), records);
    }

    protected RecordSetDefinition createRecordSetDefinition() {
        ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
        for (Column column : this.columns.getColumns()) {
            columnDefinitions.add((ColumnDefinition)column.getColumnMetadata());
        }
        return new RecordSetMetadata(columnDefinitions, null);
    }

    @Override
    public void operate(EntityMap entityMap) {
        this.columns.operate(entityMap);
        if (!this.aggregation) {
            Object[] record = (Object[])this.columns.getValue();
            ColumnRecord columnRecord = new ColumnRecord(record);
            if (this.distinct && this.cache.get(columnRecord) != null) {
                return;
            }
            this.cache.put(columnRecord, record);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.columns.clear();
        this.start = new Date();
    }

    protected class ColumnRecord {
        protected Object[] record;
        protected int hashCode = 0;

        public ColumnRecord(Object[] record) {
            this.record = record;
            for (int i = 0; i < record.length; ++i) {
                if (record[i] == null) continue;
                this.hashCode += record[i].hashCode();
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColumnRecord)) {
                return false;
            }
            return ArrayUtils.isEquals((Object)this.record, (Object)((ColumnRecord)obj).record);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

