/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.Decorator;
import org.datayoo.moql.metadata.DecorateMetadata;
import org.datayoo.moql.operand.OperandFactory;
import org.datayoo.moql.operand.function.decorator.DecorateFunction;
import org.datayoo.moql.util.StringFormater;

public class DecoratorImpl
implements Decorator {
    protected List<DecorateMetadata> decorateMetadatas;
    protected List<DecorateFunction> decorators = new LinkedList<DecorateFunction>();

    public DecoratorImpl(List<DecorateMetadata> decorateMetadatas, OperandFactory operandFactory) {
        Validate.notEmpty(decorateMetadatas, (String)"decorateMetadatas is empty!");
        Validate.notNull((Object)operandFactory, (String)"operandFactory is null!");
        this.initialize(decorateMetadatas, operandFactory);
        this.decorateMetadatas = decorateMetadatas;
    }

    protected void initialize(List<DecorateMetadata> decorateMetadatas, OperandFactory operandFactory) {
        for (DecorateMetadata decorateMetadata : decorateMetadatas) {
            try {
                Operand operand = operandFactory.createOperand(decorateMetadata.getDecorator());
                if (!(operand instanceof DecorateFunction)) {
                    throw new IllegalArgumentException(StringFormater.format((String)"The operand '{}' is not a decorator!", (Object[])new Object[]{decorateMetadata.getDecorator()}));
                }
                DecorateFunction decorator = (DecorateFunction)operand;
                this.decorators.add(decorator);
            }
            catch (MoqlException e) {
                throw new IllegalArgumentException(StringFormater.format((String)"Can't create decorator of '{}'!", (Object[])new Object[]{decorateMetadata.getDecorator()}), e);
            }
        }
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        for (DecorateFunction decorator : this.decorators) {
            recordSet = decorator.decorate(recordSet, columns);
        }
        return recordSet;
    }

    @Override
    public List<DecorateMetadata> getDecorateMetadatas() {
        return this.decorateMetadatas;
    }
}

