/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.factory;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Filter;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.Selector;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.ColumnImpl;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.ColumnsImpl;
import org.datayoo.moql.core.ColumnsRecordSetOperator;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.ConditionImpl;
import org.datayoo.moql.core.DecoratorImpl;
import org.datayoo.moql.core.HavingImpl;
import org.datayoo.moql.core.Join;
import org.datayoo.moql.core.JoinTables;
import org.datayoo.moql.core.LimitImpl;
import org.datayoo.moql.core.MoqlFactory;
import org.datayoo.moql.core.OrderImpl;
import org.datayoo.moql.core.Queryable;
import org.datayoo.moql.core.RecordSetCombination;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.SetlectorImpl;
import org.datayoo.moql.core.SingleTableTables;
import org.datayoo.moql.core.Table;
import org.datayoo.moql.core.Tables;
import org.datayoo.moql.core.combination.RecordSetCombinationFactory;
import org.datayoo.moql.core.group.GroupRecordSetOperator;
import org.datayoo.moql.core.join.JoinFactory;
import org.datayoo.moql.core.table.CommonTable;
import org.datayoo.moql.core.table.SelectorTable;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.ColumnsMetadata;
import org.datayoo.moql.metadata.ConditionMetadata;
import org.datayoo.moql.metadata.JoinMetadata;
import org.datayoo.moql.metadata.JoinType;
import org.datayoo.moql.metadata.LogicOperationMetadata;
import org.datayoo.moql.metadata.OperationMetadata;
import org.datayoo.moql.metadata.OrderMetadata;
import org.datayoo.moql.metadata.ParenMetadata;
import org.datayoo.moql.metadata.QueryableMetadata;
import org.datayoo.moql.metadata.RelationOperationMetadata;
import org.datayoo.moql.metadata.SelectorMetadata;
import org.datayoo.moql.metadata.SetlectorMetadata;
import org.datayoo.moql.metadata.TableMetadata;
import org.datayoo.moql.metadata.TablesMetadata;
import org.datayoo.moql.operand.OperandFactory;
import org.datayoo.moql.operand.expression.ParenExpression;
import org.datayoo.moql.operand.expression.logic.LogicExpressionFactory;
import org.datayoo.moql.operand.expression.relation.RelationExpressionFactory;
import org.datayoo.moql.operand.factory.OperandFactoryImpl;
import org.datayoo.moql.operand.selector.ColumnSelectorOperand;
import org.datayoo.moql.operand.selector.ValueSelectorOperand;
import org.datayoo.moql.util.StringFormater;

public class MoqlFactoryImpl
implements MoqlFactory {
    protected OperandFactory operandFactory = OperandFactoryImpl.createOperandFactory();
    protected static MoqlFactory moqlFactory;

    protected MoqlFactoryImpl() {
    }

    public static synchronized MoqlFactory createSelectorFactory() {
        if (moqlFactory == null) {
            moqlFactory = new MoqlFactoryImpl();
        }
        return moqlFactory;
    }

    @Override
    public Column createColumn(ColumnMetadata columnMetadata, boolean justUsed4Order) throws MoqlException {
        Operand operand = this.operandFactory.createOperand(columnMetadata.getValue());
        return new ColumnImpl(columnMetadata, operand, justUsed4Order);
    }

    @Override
    public Filter createFilter(ConditionMetadata conditionMetadata) throws MoqlException {
        return this.createCondition(conditionMetadata, null);
    }

    protected Condition createCondition(ConditionMetadata conditionMetadata, SelectorImpl selector) throws MoqlException {
        OperationMetadata operationMetadata = conditionMetadata.getOperation();
        Operand operand = this.createOperand(operationMetadata, selector);
        return new ConditionImpl(conditionMetadata, operand);
    }

    protected Operand createOperand(OperationMetadata operationMetadata, SelectorImpl selector) throws MoqlException {
        Operand operand = null;
        if (operationMetadata instanceof LogicOperationMetadata) {
            operand = this.createLogicOperand((LogicOperationMetadata)operationMetadata, selector);
        } else if (operationMetadata instanceof RelationOperationMetadata) {
            operand = this.createRelationOperand((RelationOperationMetadata)operationMetadata, selector);
        } else if (operationMetadata instanceof ParenMetadata) {
            ParenMetadata parenMetadata = (ParenMetadata)operationMetadata;
            operand = this.createOperand(parenMetadata.getOperand(), selector);
            operand = new ParenExpression(operand);
        }
        return operand;
    }

    protected Operand createLogicOperand(LogicOperationMetadata logicOperationMetadata, SelectorImpl selector) throws MoqlException {
        Operand lOperand = null;
        if (!LogicExpressionFactory.isUnary(logicOperationMetadata.getOperator())) {
            OperationMetadata lOperationMetadata = logicOperationMetadata.getLeftOperand();
            lOperand = this.createOperand(lOperationMetadata, selector);
        }
        Operand rOperand = this.createOperand(logicOperationMetadata.getRightOperand(), selector);
        return LogicExpressionFactory.createLogicExpression(logicOperationMetadata.getOperator(), lOperand, rOperand);
    }

    protected Operand createRelationOperand(RelationOperationMetadata relationOperationMetadata, SelectorImpl selector) throws MoqlException {
        Operand lOperand = null;
        if (!RelationExpressionFactory.isUnary(relationOperationMetadata.getOperator())) {
            lOperand = this.operandFactory.createOperand(relationOperationMetadata.getLeftOperand());
        }
        Operand rOperand = null;
        if (relationOperationMetadata.getNestedSelector() != null) {
            if (selector == null) {
                throw new MoqlException("Doesn't support nested selector in condition!");
            }
            Selector nestedSelector = this.createSelector(relationOperationMetadata.getNestedSelector());
            selector.getNestedTableSelectors().add(nestedSelector);
            rOperand = new ColumnSelectorOperand(nestedSelector);
        } else {
            rOperand = this.operandFactory.createOperand(relationOperationMetadata.getRightOperand());
        }
        return RelationExpressionFactory.createRelationExpression(relationOperationMetadata.getOperator(), lOperand, rOperand);
    }

    @Override
    public Selector createSelector(SelectorDefinition selectorDefinition) throws MoqlException {
        Selector selector = selectorDefinition instanceof SelectorMetadata ? this.baseCreateSelector((SelectorMetadata)selectorDefinition) : this.baseCreateSetlector((SetlectorMetadata)selectorDefinition);
        return selector;
    }

    protected Selector baseCreateSelector(SelectorMetadata selectorMetadata) throws MoqlException {
        Condition condition;
        SelectorImpl selector = new SelectorImpl(selectorMetadata);
        Tables tables = this.createTables(selectorMetadata.getTables(), selector);
        selector.setTables(tables);
        Columns columns = this.createColumns(selectorMetadata.getColumns(), selectorMetadata.getOrderBy(), selector);
        RecordSetOperator recordSetOperator = selectorMetadata.getGroupBy() == null || selectorMetadata.getGroupBy().size() == 0 ? new ColumnsRecordSetOperator(selectorMetadata.getCache(), columns) : new GroupRecordSetOperator(selectorMetadata.getCache(), columns, selectorMetadata.getGroupBy(), this);
        selector.setRecordSetOperator(recordSetOperator);
        if (selectorMetadata.getWhere() != null) {
            condition = this.createCondition(selectorMetadata.getWhere(), selector);
            selector.setWhere(condition);
        }
        if (selectorMetadata.getHaving() != null) {
            condition = this.createCondition(selectorMetadata.getHaving(), selector);
            HavingImpl having = new HavingImpl(condition);
            selector.setHaving(having);
        }
        if (selectorMetadata.getOrderBy() != null && selectorMetadata.getOrderBy().size() != 0) {
            OrderImpl order = new OrderImpl(columns, selectorMetadata.getOrderBy());
            selector.setOrder(order);
        }
        if (selectorMetadata.getLimit() != null) {
            LimitImpl limit = new LimitImpl(selectorMetadata.getLimit());
            selector.setLimit(limit);
        }
        if (selectorMetadata.getDecorateBy() != null && selectorMetadata.getDecorateBy().size() != 0) {
            DecoratorImpl decorator = new DecoratorImpl(selectorMetadata.getDecorateBy(), this.operandFactory);
            selector.setDecorator(decorator);
        }
        return selector;
    }

    protected Tables createTables(TablesMetadata tablesMetadata, SelectorImpl selector) throws MoqlException {
        List queryableMetadatas = tablesMetadata.getTables();
        if (queryableMetadatas.size() == 1) {
            if (queryableMetadatas.get(0) instanceof TableMetadata) {
                Table table = this.createTable((TableMetadata)queryableMetadatas.get(0), selector);
                return new SingleTableTables(tablesMetadata, table);
            }
            Join join = this.createJoin((JoinMetadata)queryableMetadatas.get(0), selector);
            return new JoinTables(tablesMetadata, join);
        }
        Join join = this.createJoin(queryableMetadatas, selector);
        return new JoinTables(tablesMetadata, join);
    }

    protected Table createTable(TableMetadata tableMetadata, SelectorImpl selector) throws MoqlException {
        if (tableMetadata.getNestedSelector() != null) {
            Selector nestedSelector = this.createSelector(tableMetadata.getNestedSelector());
            nestedSelector.setAlias(tableMetadata.getName());
            selector.getNestedTableSelectors().add(nestedSelector);
            return new SelectorTable(tableMetadata, nestedSelector);
        }
        return new CommonTable(tableMetadata);
    }

    protected Join createJoin(JoinMetadata joinMetadata, SelectorImpl selector) throws MoqlException {
        Condition on = null;
        Queryable<EntityMap> lQueryable = joinMetadata.getLQueryable() instanceof JoinMetadata ? this.createJoin((JoinMetadata)joinMetadata.getLQueryable(), selector) : this.createTable((TableMetadata)joinMetadata.getLQueryable(), selector);
        Queryable<EntityMap> rQueryable = joinMetadata.getRQueryable() instanceof JoinMetadata ? this.createJoin((JoinMetadata)joinMetadata.getRQueryable(), selector) : this.createTable((TableMetadata)joinMetadata.getRQueryable(), selector);
        if (joinMetadata.getOn() != null) {
            on = this.createCondition(joinMetadata.getOn(), selector);
        }
        return JoinFactory.createJoin(joinMetadata, lQueryable, rQueryable, on);
    }

    protected Join createJoin(List<QueryableMetadata> queryableMetadatas, SelectorImpl selector) throws MoqlException {
        Queryable<Object> lQueryable = null;
        Queryable<Object> rQueryable = null;
        QueryableMetadata lQueryableMetadata = null;
        for (QueryableMetadata queryableMetadata : queryableMetadatas) {
            if (lQueryable == null) {
                lQueryable = queryableMetadata instanceof TableMetadata ? this.createTable((TableMetadata)queryableMetadata, selector) : this.createJoin((JoinMetadata)queryableMetadata, selector);
                lQueryableMetadata = queryableMetadata;
                continue;
            }
            rQueryable = queryableMetadata instanceof TableMetadata ? this.createTable((TableMetadata)queryableMetadata, selector) : this.createJoin((JoinMetadata)queryableMetadata, selector);
            JoinMetadata joinMetadata = new JoinMetadata(JoinType.INNER, lQueryableMetadata, queryableMetadata);
            lQueryable = JoinFactory.createJoin(joinMetadata, lQueryable, rQueryable, null);
            lQueryableMetadata = joinMetadata;
        }
        return (Join)lQueryable;
    }

    protected Columns createColumns(ColumnsMetadata columnsMetadata, List<OrderMetadata> orderMetadatas, SelectorImpl selector) throws MoqlException {
        LinkedList<Column> columns = new LinkedList<Column>();
        for (ColumnMetadata columnMetadata : columnsMetadata.getColumns()) {
            Column column = this.createColumn(columnMetadata, selector.getNestedColumnSelectors());
            columns.add(column);
        }
        if (orderMetadatas != null) {
            for (OrderMetadata orderMetadata : orderMetadatas) {
                String column = orderMetadata.getColumn();
                try {
                    int index = Integer.valueOf(column);
                    if (index <= columns.size() && index >= 0) continue;
                    throw new MoqlException(StringFormater.format((String)"Order index {} is out of boundary!", (Object[])new Object[]{index}));
                }
                catch (Throwable index) {
                    if (this.findColumnMetadata(column, columnsMetadata.getColumns()) != null) continue;
                    ColumnMetadata columnMetadata = new ColumnMetadata(column, column);
                    Operand operand = this.operandFactory.createOperand(columnMetadata.getValue());
                    columns.add(new ColumnImpl(columnMetadata, operand, true));
                }
            }
        }
        return new ColumnsImpl(columnsMetadata, columns);
    }

    protected ColumnMetadata findColumnMetadata(String name, List<ColumnMetadata> columnMetadatas) {
        for (ColumnMetadata columnMetadata : columnMetadatas) {
            if (!columnMetadata.getName().equals(name)) continue;
            return columnMetadata;
        }
        return null;
    }

    protected Column createColumn(ColumnMetadata columnMetadata, List<Selector> nestedColumnSelectors) throws MoqlException {
        if (columnMetadata.getNestedSelector() == null) {
            Operand operand = null;
            operand = this.operandFactory.createOperand(columnMetadata.getValue());
            return new ColumnImpl(columnMetadata, operand);
        }
        Selector nestedSelector = this.createSelector(columnMetadata.getNestedSelector());
        nestedSelector.setAlias(columnMetadata.getName());
        nestedColumnSelectors.add(nestedSelector);
        ValueSelectorOperand operand = new ValueSelectorOperand(nestedSelector);
        return new ColumnImpl(columnMetadata, operand);
    }

    protected Selector baseCreateSetlector(SetlectorMetadata setlectorMetadata) throws MoqlException {
        SetlectorImpl setlector = new SetlectorImpl(setlectorMetadata);
        RecordSetCombination combination = RecordSetCombinationFactory.createRecordSetCombination(setlectorMetadata.getCombinationType(), setlectorMetadata.getColumns());
        setlector.setCombination(combination);
        for (SelectorDefinition selectorDefinition : setlectorMetadata.getSets()) {
            Selector selector = this.createSelector(selectorDefinition);
            setlector.getNestedSelectors().add(selector);
            setlector.getSets().add(selector);
        }
        if (setlectorMetadata.getOrderBy() != null && setlectorMetadata.getOrderBy().size() != 0) {
            ColumnsMetadata columnsMetadata = this.getColumnsMetadata((SelectorDefinition)setlectorMetadata);
            Columns columns = this.createColumns(columnsMetadata, setlector);
            OrderImpl order = new OrderImpl(columns, setlectorMetadata.getOrderBy());
            setlector.setOrder(order);
        }
        if (setlectorMetadata.getLimit() != null) {
            LimitImpl limit = new LimitImpl(setlectorMetadata.getLimit());
            setlector.setLimit(limit);
        }
        if (setlectorMetadata.getDecorateBy() != null && setlectorMetadata.getDecorateBy().size() != 0) {
            DecoratorImpl decorator = new DecoratorImpl(setlectorMetadata.getDecorateBy(), this.operandFactory);
            setlector.setDecorator(decorator);
        }
        return setlector;
    }

    protected ColumnsMetadata getColumnsMetadata(SelectorDefinition selectorDefinition) {
        if (selectorDefinition instanceof SelectorMetadata) {
            return ((SelectorMetadata)selectorDefinition).getColumns();
        }
        SetlectorMetadata setlectorMetadata = (SetlectorMetadata)selectorDefinition;
        if (setlectorMetadata.getColumns().getColumns().size() == 0) {
            SelectorDefinition lSelectorDefinition = (SelectorDefinition)setlectorMetadata.getSets().get(0);
            return this.getColumnsMetadata(lSelectorDefinition);
        }
        return setlectorMetadata.getColumns();
    }

    protected Columns createColumns(ColumnsMetadata columnsMetadata, SetlectorImpl setlector) throws MoqlException {
        LinkedList<Column> columns = new LinkedList<Column>();
        for (ColumnMetadata columnMetadata : columnsMetadata.getColumns()) {
            Column column = this.createColumn(columnMetadata, new LinkedList<Selector>());
            columns.add(column);
        }
        return new ColumnsImpl(columnsMetadata, columns);
    }

    public OperandFactory getOperandFactory() {
        return this.operandFactory;
    }

    public void setOperandFactory(OperandFactory operandFactory) {
        Validate.notNull((Object)operandFactory, (String)"Parameter 'operandFactory' is null!");
        this.operandFactory = operandFactory;
    }

    class SelectorBean {
        protected SelectorDefinition definition;
        protected Selector selector;

        public SelectorBean(SelectorDefinition definition) {
            Validate.notNull((Object)definition, (String)"Parameter 'definition' is null!");
            this.definition = definition;
        }

        public SelectorDefinition getDefinition() {
            return this.definition;
        }

        public Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Selector selector) {
            Validate.notNull((Object)selector, (String)"Parameter 'selector' is null!");
            this.selector = selector;
        }
    }
}

