/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.group;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.MoqlGrammarException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperateException;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.Cache;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.Group;
import org.datayoo.moql.core.MoqlFactory;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.core.RecordSetMetadata;
import org.datayoo.moql.core.cache.CacheImpl;
import org.datayoo.moql.core.group.GroupKey;
import org.datayoo.moql.core.group.GroupRecord;
import org.datayoo.moql.core.group.GroupRecordConverter;
import org.datayoo.moql.metadata.CacheMetadata;
import org.datayoo.moql.metadata.GroupMetadata;
import org.datayoo.moql.operand.function.AggregationFunction;
import org.datayoo.moql.util.StringFormater;

public class GroupRecordSetOperator
implements Group {
    protected Cache<GroupKey, GroupRecord> cache;
    protected Columns columns;
    protected List<GroupMetadata> groupMetadatas;
    protected MoqlFactory moqlFactory;
    protected Column[] groupColumns;
    protected int[] groupColumnIndexes;
    protected Column[] nonGroupColumns;
    protected Date start;
    protected GroupRecordConverter groupRecordConverter = new GroupRecordConverter();
    protected GroupKey tempGroupKey = new GroupKey();

    public GroupRecordSetOperator(CacheMetadata cacheMetadata, Columns columns, List<GroupMetadata> groupMetadatas, MoqlFactory moqlFactory) throws MoqlGrammarException {
        Validate.notNull((Object)cacheMetadata, (String)"Parameter 'cacheMetadata' is null!");
        Validate.notNull((Object)columns, (String)"Parameter 'columns' is null!");
        Validate.notEmpty(groupMetadatas, (String)"Parameter 'groupMetadatas' is empty!");
        Validate.notNull((Object)moqlFactory, (String)"Parameter 'moqlFactory' is null!");
        this.cache = new CacheImpl<GroupKey, GroupRecord>(cacheMetadata);
        this.columns = columns;
        this.groupMetadatas = groupMetadatas;
        this.moqlFactory = moqlFactory;
        this.initialize();
        this.start = new Date();
    }

    protected void initialize() throws MoqlGrammarException {
        this.groupColumns = new Column[this.groupMetadatas.size()];
        this.groupColumnIndexes = new int[this.groupMetadatas.size()];
        this.nonGroupColumns = new Column[this.columns.getColumns().size()];
        this.columns.getColumns().toArray(this.nonGroupColumns);
        int i = 0;
        for (GroupMetadata groupMetadata : this.groupMetadatas) {
            int index = this.getGroupColumnIndex(groupMetadata, this.columns.getColumns());
            if (index > this.columns.getColumns().size() || index < 1) {
                throw new MoqlGrammarException(StringFormater.format((String)"Group column indexed '{}' out of columns' bound!", (Object[])new Object[]{index}));
            }
            this.groupColumns[i] = this.nonGroupColumns[--index];
            this.groupColumnIndexes[i++] = index;
            this.nonGroupColumns[index] = null;
        }
        this.checkNonGroupColumns();
    }

    protected void checkNonGroupColumns() throws MoqlGrammarException {
        for (int i = 0; i < this.nonGroupColumns.length; ++i) {
            Operand operand;
            if (this.nonGroupColumns[i] == null || this.nonGroupColumns[i].isJustUsed4Order() || (operand = this.nonGroupColumns[i].getOperand()) instanceof AggregationFunction) continue;
            throw new MoqlGrammarException(StringFormater.format((String)"Nongroup column '{}' is not a function expression!", (Object[])new Object[]{this.nonGroupColumns[i].getColumnMetadata().getName()}));
        }
    }

    protected int getGroupColumnIndex(GroupMetadata groupMetadata, List<Column> columns) throws MoqlGrammarException {
        String columnName = groupMetadata.getColumn();
        int index = 1;
        try {
            index = Integer.valueOf(columnName);
            return index;
        }
        catch (Throwable throwable) {
            for (Column column : columns) {
                if (column.getColumnMetadata().getName().equals(columnName)) {
                    return index;
                }
                if (column.getColumnMetadata().getValue().equals(columnName)) {
                    return index;
                }
                ++index;
            }
            throw new MoqlGrammarException(StringFormater.format((String)"Group column '{}' doesn't existed in colums!", (Object[])new Object[]{columnName}));
        }
    }

    @Override
    public List<GroupMetadata> getGroupMetadatas() {
        return this.groupMetadatas;
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    @Override
    public Columns getColumns() {
        return this.columns;
    }

    public Column[] getGroupColumns() {
        return this.groupColumns;
    }

    public Column[] getNonGroupColumns() {
        return this.nonGroupColumns;
    }

    @Override
    public RecordSet getValue() {
        RecordSetDefinition recordSetDefinition = this.createRecordSetDefinition();
        return new RecordSetImpl(recordSetDefinition, this.start, new Date(), this.cache.values(this.groupRecordConverter));
    }

    protected RecordSetDefinition createRecordSetDefinition() {
        ArrayList<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
        for (Column column : this.columns.getColumns()) {
            columnDefinitions.add((ColumnDefinition)column.getColumnMetadata());
        }
        ArrayList<ColumnDefinition> groupDefinitions = new ArrayList<ColumnDefinition>();
        for (Column column : this.groupColumns) {
            groupDefinitions.add((ColumnDefinition)column.getColumnMetadata());
        }
        return new RecordSetMetadata(columnDefinitions, groupDefinitions);
    }

    @Override
    public synchronized void operate(EntityMap entityMap) {
        this.fillTempGroupKey(entityMap);
        GroupRecord record = this.cache.get(this.tempGroupKey);
        if (record == null) {
            try {
                record = this.createGroupRecord(this.tempGroupKey.groups);
                this.cache.put(this.tempGroupKey, record);
                this.tempGroupKey = new GroupKey();
            }
            catch (MoqlException e) {
                throw new OperateException(e);
            }
        }
        record.operate(entityMap);
    }

    protected void fillTempGroupKey(EntityMap entityMap) {
        Object[] values = new Object[this.groupColumns.length];
        for (int i = 0; i < this.groupColumns.length; ++i) {
            this.groupColumns[i].operate(entityMap);
            values[i] = this.groupColumns[i].getValue();
        }
        this.tempGroupKey.initialize(values);
    }

    protected GroupRecord createGroupRecord(Object[] groupKeys) throws MoqlException {
        Column[] columns = new Column[this.nonGroupColumns.length];
        for (int i = 0; i < this.nonGroupColumns.length; ++i) {
            Column column;
            if (this.nonGroupColumns[i] == null) continue;
            columns[i] = column = this.moqlFactory.createColumn(this.nonGroupColumns[i].getColumnMetadata(), this.nonGroupColumns[i].isJustUsed4Order());
        }
        return new GroupRecord(groupKeys, this.groupColumnIndexes, columns);
    }

    @Override
    public void clear() {
        this.cache.clear();
        for (Column column : this.groupColumns) {
            column.clear();
        }
        this.start = new Date();
    }
}

