/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.data.ColumnFeature;
import org.datayoo.moql.data.FeatureDecisionor;
import org.datayoo.moql.data.GeneralFeatureDecisionor;

public abstract class DataPlanningUtils {
    public static List<ColumnFeature> analyzeColumns(List<Object[]> recordSet, String[] columnHeaders, FeatureDecisionor featureDecisionor) {
        Validate.notEmpty(recordSet, (String)"recordSet is empty!");
        if (featureDecisionor == null) {
            featureDecisionor = new GeneralFeatureDecisionor();
        }
        ColumnFeature[] columns = DataPlanningUtils.createColumnFeatures(recordSet.get(0), columnHeaders, featureDecisionor);
        DataPlanningUtils.caculate(recordSet, columns);
        return Arrays.asList(columns);
    }

    protected static ColumnFeature[] createColumnFeatures(Object[] record, String[] columnHeaders, FeatureDecisionor featureDecisionor) {
        ColumnFeature[] columns = new ColumnFeature[record.length];
        if (columnHeaders != null) {
            Validate.isTrue((record.length == columnHeaders.length ? 1 : 0) != 0, (String)"columnHeaders is invalid!");
            for (int i = 0; i < record.length; ++i) {
                columns[i] = new ColumnFeature(columnHeaders[i], featureDecisionor);
            }
        } else {
            for (int i = 0; i < record.length; ++i) {
                columns[i] = new ColumnFeature(String.valueOf(i), featureDecisionor);
            }
        }
        return columns;
    }

    protected static void caculate(List<Object[]> recordSet, ColumnFeature[] columns) {
        for (Object[] record : recordSet) {
            for (int i = 0; i < record.length; ++i) {
                columns[i].addValue(record[i]);
            }
        }
    }

    public static List<ColumnFeature> analyzeColumns(List<Map<String, Object>> recordSet, FeatureDecisionor featureDecisionor) {
        Validate.notEmpty(recordSet, (String)"recordSet is empty!");
        if (featureDecisionor == null) {
            featureDecisionor = new GeneralFeatureDecisionor();
        }
        Map<String, ColumnFeature> columnFeatureMap = DataPlanningUtils.createColumnFeatures(recordSet.get(0), featureDecisionor);
        DataPlanningUtils.caculate(recordSet, columnFeatureMap);
        return new ArrayList<ColumnFeature>(columnFeatureMap.values());
    }

    protected static Map<String, ColumnFeature> createColumnFeatures(Map<String, Object> record, FeatureDecisionor featureDecisionor) {
        HashMap<String, ColumnFeature> columnFeatureMap = new HashMap<String, ColumnFeature>();
        for (String columnName : record.keySet()) {
            ColumnFeature columnFeature = new ColumnFeature(columnName, featureDecisionor);
            columnFeatureMap.put(columnName, columnFeature);
        }
        return columnFeatureMap;
    }

    protected static void caculate(List<Map<String, Object>> recordSet, Map<String, ColumnFeature> columnFeatureMap) {
        for (Map<String, Object> record : recordSet) {
            for (Map.Entry<String, Object> entry : record.entrySet()) {
                ColumnFeature columnFeature = columnFeatureMap.get(entry.getKey());
                if (columnFeature == null) continue;
                columnFeature.addValue(entry.getValue());
            }
        }
    }

    public static List<ColumnFeature> getDimensionColumns(List<ColumnFeature> columnFeatures) {
        ArrayList<ColumnFeature> result = new ArrayList<ColumnFeature>(columnFeatures.size());
        for (ColumnFeature columnFeature : columnFeatures) {
            if (!columnFeature.isDimension()) continue;
            result.add(columnFeature);
        }
        return result;
    }
}

