/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.array;

import org.apache.commons.lang.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.array.ArrayAccessor;
import org.datayoo.moql.operand.expression.array.ArrayExpressionUtils;

public class ArrayExpression
extends AbstractExpression {
    protected Operand array;
    protected Operand index;

    public ArrayExpression(Operand array, Operand index) {
        this.expressionType = ExpressionType.ARRAY;
        Validate.notNull((Object)array, (String)"array is null!");
        this.array = array;
        this.index = index;
        this.name = this.buildNameString();
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.array.toString());
        sbuf.append('[');
        if (this.index != null) {
            sbuf.append(this.index.toString());
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    @Override
    public Object operate(EntityMap entityMap) {
        Object o = this.array.operate(entityMap);
        if (o == null) {
            return null;
        }
        ArrayAccessor arrayAccessor = ArrayExpressionUtils.getArrayAccessor(o);
        if (this.index != null) {
            Object inx = this.index.operate(entityMap);
            return arrayAccessor.getObject(o, inx);
        }
        return arrayAccessor.toOperandContextList(o);
    }
}

