/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.array;

import java.util.Iterator;
import org.datayoo.moql.NumberConvertable;
import org.datayoo.moql.operand.OperandContextLinkedList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.array.ArrayAccessor;
import org.datayoo.moql.util.StringFormater;

public class IteratorAccessor
implements ArrayAccessor {
    @Override
    public Object getObject(Object array, Object index) {
        Iterator<Object> it = ((Iterable)array).iterator();
        if (index instanceof Number) {
            return this.getObject(it, ((Number)index).intValue());
        }
        if (index instanceof NumberConvertable) {
            Number inx = ((NumberConvertable)index).toNumber();
            return this.getObject(it, inx.intValue());
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsupport 'index' of class '{}'!", (Object[])new Object[]{index.getClass().getName()}));
    }

    protected Object getObject(Iterator<Object> it, int index) {
        int i = 0;
        while (it.hasNext()) {
            Object o = it.next();
            if (i++ != index) continue;
            return o;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public OperandContextList toOperandContextList(Object array) {
        Iterator it = ((Iterable)array).iterator();
        OperandContextLinkedList ctxList = new OperandContextLinkedList();
        while (it.hasNext()) {
            ctxList.add(it.next());
        }
        return ctxList;
    }
}

