/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.relation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.constant.StringConstant;
import org.datayoo.moql.operand.expression.relation.AbstractRelationExpression;
import org.datayoo.moql.operand.expression.relation.RelationOperator;
import org.datayoo.moql.util.StringFormater;

public class LikeExpression
extends AbstractRelationExpression {
    protected Pattern pattern;

    public LikeExpression(Operand lOperand, Operand rOperand) {
        super(OperatorType.BINARY, RelationOperator.LIKE, lOperand, rOperand);
        if (!(rOperand instanceof StringConstant)) {
            throw new IllegalArgumentException("Parameter 'rOperand' is not a String");
        }
        String data = (String)rOperand.operate(null);
        String regex = LikeExpression.translatePattern2Regex(data);
        this.pattern = Pattern.compile(regex, 8);
    }

    public static String translatePattern2Regex(String pattern) {
        StringBuffer sbuf = new StringBuffer(pattern.length() * 2);
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == "%".charAt(0)) {
                sbuf.append("[^\f]*");
                continue;
            }
            if (ch == '_') {
                sbuf.append('.');
                continue;
            }
            if (ch == '.') {
                sbuf.append(".");
                continue;
            }
            if (ch == '\\') {
                if ((ch = pattern.charAt(++i)) == "%".charAt(0)) {
                    sbuf.append("%");
                    continue;
                }
                if (ch == '_') {
                    sbuf.append('_');
                    continue;
                }
                if (ch == '\\') {
                    sbuf.append("\\\\");
                    continue;
                }
                throw new IllegalArgumentException(StringFormater.format((String)"Invalid escape char at {} of search pattern '{}'!", (Object[])new Object[]{i, pattern}));
            }
            sbuf.append(ch);
        }
        return sbuf.toString();
    }

    @Override
    public Object operate(EntityMap entityMap) {
        Object value = this.lOperand.operate(entityMap);
        if (value == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(value.toString());
        return matcher.matches();
    }
}

