/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AggregationFunction;

public class Avg
extends AggregationFunction {
    public static final String FUNCTION_NAME = "avg";
    protected Operand operand;
    protected double sum = 0.0;
    protected long count = 0L;

    public Avg(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.operand = parameters.get(0);
    }

    @Override
    public void increment(EntityMap entityMap) {
        Object obj = this.operand.operate(entityMap);
        ++this.count;
        if (obj == null) {
            return;
        }
        Number num = this.toNumber(obj);
        this.sum += num.doubleValue();
    }

    @Override
    public Object getValue() {
        return new Double(this.sum / (double)this.count);
    }

    @Override
    public synchronized void clear() {
        this.sum = 0.0;
        this.count = 0L;
    }
}

