/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AggregationFunction;
import org.datayoo.moql.util.StringFormater;

public class Count
extends AggregationFunction {
    public static final String FUNCTION_NAME = "count";
    protected long count = 0L;
    protected Operand operand = null;
    protected boolean distinct = false;
    protected Set<Object> cache = new HashSet<Object>();

    public Count(List<Operand> parameters) {
        super(FUNCTION_NAME, -1, parameters);
        if (this.parameters.size() > 2) {
            throw new IllegalArgumentException(StringFormater.format((String)"Function '{}' need 1 or 2 parameters!", (Object[])new Object[]{this.name}));
        }
        if (parameters.size() == 2) {
            Object object = parameters.get(1).operate(null);
            if (object instanceof Boolean) {
                this.distinct = (Boolean)object;
            }
            if (this.distinct) {
                this.operand = parameters.get(0);
            }
        }
    }

    @Override
    public void increment(EntityMap entityMap) {
        if (!this.distinct) {
            ++this.count;
        } else {
            Object value = this.operand.operate(entityMap);
            if (this.cache.add(value)) {
                ++this.count;
            }
        }
    }

    @Override
    public Object getValue() {
        return new Long(this.count);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void clear() {
        this.count = 0L;
        this.cache.clear();
    }
}

