/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.text.DecimalFormat;
import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AbstractFunction;
import org.datayoo.moql.util.StringFormater;

public class Percent
extends AbstractFunction {
    public static final String FUNCTION_NAME = "percent";
    protected int precision = 0;
    protected DecimalFormat decimalFormat;

    public Percent(List<Operand> parameters) {
        super(FUNCTION_NAME, 2, parameters);
        Object object = parameters.get(1).operate(null);
        this.precision = Integer.valueOf(object.toString());
        if (this.precision > 0) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("0.0");
            for (int i = 1; i < this.precision; ++i) {
                sbuf.append('0');
            }
            this.decimalFormat = new DecimalFormat(sbuf.toString());
        }
    }

    @Override
    protected Object innerOperate(EntityMap entityMap) {
        Object obj = ((Operand)this.parameters.get(0)).operate(entityMap);
        if (obj == null) {
            return "N/A";
        }
        double val = 0.0;
        if (obj instanceof Number) {
            Number num = (Number)obj;
            val = num.doubleValue();
        } else {
            val = Double.valueOf(obj.toString());
        }
        val *= 100.0;
        if (this.precision == 0) {
            return StringFormater.format((String)"{}%", (Object[])new Object[]{(long)val});
        }
        if ((double)((long)val) == val) {
            return StringFormater.format((String)"{}%", (Object[])new Object[]{(long)val});
        }
        if (Double.isNaN(val)) {
            return String.valueOf(val);
        }
        return StringFormater.format((String)"{}%", (Object[])new Object[]{this.decimalFormat.format(val)});
    }
}

