/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.constant.ConstantType;
import org.datayoo.moql.operand.function.AggregationFunction;
import org.datayoo.moql.util.CompareHelper;

public class Range
extends AggregationFunction {
    public static final String FUNCTION_NAME = "range";
    protected Number max;
    protected ConstantType maxType;
    protected Number min;
    protected ConstantType minType;

    public Range(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
    }

    @Override
    public void increment(EntityMap entityMap) {
        Object obj = ((Operand)this.parameters.get(0)).operate(entityMap);
        if (obj == null) {
            return;
        }
        Number num = this.toNumber(obj);
        ConstantType numType = this.getConstantType(num);
        if (this.max == null) {
            this.max = num;
            this.maxType = numType;
            this.min = num;
            this.minType = numType;
        } else if (CompareHelper.compare(this.max, (Object)num) < 0) {
            this.max = num;
            this.maxType = numType;
        } else if (CompareHelper.compare(this.min, (Object)num) > 0) {
            this.min = num;
            this.minType = numType;
        }
    }

    protected ConstantType getConstantType(Number number) {
        if (number instanceof Float || number instanceof Double) {
            return ConstantType.DOUBLE;
        }
        return ConstantType.LONG;
    }

    @Override
    public Object getValue() {
        if (this.maxType == ConstantType.LONG && this.minType == ConstantType.LONG) {
            return this.max.longValue() - this.min.longValue();
        }
        return this.max.doubleValue() - this.min.doubleValue();
    }

    @Override
    public void clear() {
        this.max = null;
        this.min = null;
    }
}

