/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.constant.ConstantType;
import org.datayoo.moql.operand.function.AggregationFunction;

public class Sum
extends AggregationFunction {
    public static final String FUNCTION_NAME = "sum";
    protected Operand operand;
    protected Number sum = new Long(0L);
    protected ConstantType sumType = ConstantType.LONG;

    public Sum(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.operand = parameters.get(0);
    }

    @Override
    public void increment(EntityMap entityMap) {
        Object obj = this.operand.operate(entityMap);
        if (obj == null) {
            return;
        }
        Number num = this.toNumber(obj);
        ConstantType numType = this.getConstantType(num);
        if (this.sum == null) {
            this.sum = num;
            this.sumType = numType;
        } else if (this.sumType == ConstantType.DOUBLE || numType == ConstantType.DOUBLE) {
            this.sum = new Double(this.sum.doubleValue() + num.doubleValue());
            this.sumType = ConstantType.DOUBLE;
        } else {
            this.sum = new Long(this.sum.longValue() + num.longValue());
        }
    }

    @Override
    public Object getValue() {
        return this.sum;
    }

    protected ConstantType getConstantType(Number number) {
        if (number instanceof Float || number instanceof Double) {
            return ConstantType.DOUBLE;
        }
        return ConstantType.LONG;
    }

    @Override
    public synchronized void clear() {
        this.sum = new Long(0L);
    }
}

