/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function.decorator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datayoo.moql.Operand;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.group.GroupKey;
import org.datayoo.moql.operand.function.decorator.DecorateFunction;
import org.datayoo.moql.util.StringFormater;

public class GroupOrdinal
extends DecorateFunction {
    public static final String FUNCTION_NAME = "groupOrdinal";
    protected String[] groupColumns;
    protected int[] groupColumnIndexes;
    protected String valueColumn;
    protected int valueColumnIndex;
    protected Map<GroupKey, RowNumberSequence> groupNumberSequences = new HashMap<GroupKey, RowNumberSequence>();
    protected GroupKey tempGroupKey = new GroupKey();

    public GroupOrdinal(List<Operand> parameters) {
        super(FUNCTION_NAME, 2, parameters);
        String groupColumnsString = (String)parameters.get(0).operate(null);
        if (groupColumnsString == null || groupColumnsString.isEmpty()) {
            throw new IllegalArgumentException("groupColumns is empty!");
        }
        this.groupColumns = groupColumnsString.split(",");
        this.valueColumn = (String)parameters.get(1).operate(null);
        if (this.valueColumn == null || this.valueColumn.isEmpty()) {
            throw new IllegalArgumentException("valueColumn is empty!");
        }
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        if (recordSet == null) {
            return null;
        }
        this.initialize(recordSet);
        List<Object[]> records = recordSet.getRecords();
        for (Object[] record : records) {
            RowNumberSequence rowNumberSequence = this.getRowNumberSequence(record);
            record[this.valueColumnIndex] = ++rowNumberSequence.sequence;
        }
        return recordSet;
    }

    protected void initialize(RecordSet recordSet) {
        RecordSetDefinition recordSetDefinition = recordSet.getRecordSetDefinition();
        this.groupColumnIndexes = new int[this.groupColumns.length];
        for (int i = 0; i < this.groupColumns.length; ++i) {
            this.groupColumnIndexes[i] = recordSetDefinition.getColumnIndex(this.groupColumns[i]);
            if (this.groupColumnIndexes[i] != -1) continue;
            throw new IllegalArgumentException(StringFormater.format((String)"Record set has no column named '{}'!", (Object[])new Object[]{this.groupColumns[i]}));
        }
        this.valueColumnIndex = recordSetDefinition.getColumnIndex(this.valueColumn);
        if (this.valueColumnIndex == -1) {
            throw new IllegalArgumentException(StringFormater.format((String)"Record set has no column named '{}'!", (Object[])new Object[]{this.valueColumn}));
        }
    }

    protected RowNumberSequence getRowNumberSequence(Object[] record) {
        this.fillTempGroupKey(record);
        RowNumberSequence rowNumberSequence = this.groupNumberSequences.get(this.tempGroupKey);
        if (rowNumberSequence == null) {
            rowNumberSequence = new RowNumberSequence();
            this.groupNumberSequences.put(this.tempGroupKey, rowNumberSequence);
            this.tempGroupKey = new GroupKey();
        }
        return rowNumberSequence;
    }

    protected void fillTempGroupKey(Object[] record) {
        Object[] values = new Object[this.groupColumns.length];
        for (int i = 0; i < this.groupColumns.length; ++i) {
            values[i] = record[this.groupColumnIndexes[i]];
        }
        this.tempGroupKey.initialize(values);
    }

    protected class RowNumberSequence {
        public int sequence = 0;
    }
}

