/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function.decorator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.Operand;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.core.RecordSetMetadata;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.operand.function.decorator.DecorateFunction;
import org.datayoo.moql.util.StringFormater;

public class MultiDimTranslation
extends DecorateFunction {
    public static final String FUNCTION_NAME = "multiDimTranslation";
    public static final String COLUMN_YAXIS = "YAXIS";
    protected boolean hasGroup = false;
    protected String[] xAxises;
    protected int[] xAxisIndexes;
    protected String[] yAxises;
    protected int[] yAxisIndexes;
    protected String[] measures;
    protected String[] measureMethods;
    protected int[] measureIndexes;

    public MultiDimTranslation(List<Operand> parameters) {
        super(FUNCTION_NAME, parameters);
        if (parameters.size() != 3) {
            throw new IllegalArgumentException("Invalid function format! The format should be 'multiDimTranslation(xAxisColumns, yAxisColumns, measureColumns)'");
        }
        String parameter = (String)parameters.get(0).operate(null);
        if (parameter != null) {
            this.xAxises = parameter.split(",");
            this.trim(this.xAxises);
        }
        if ((parameter = (String)parameters.get(1).operate(null)) != null) {
            this.yAxises = parameter.split(",");
            this.trim(this.yAxises);
        }
        if ((parameter = (String)parameters.get(2).operate(null)) == null || parameter.isEmpty()) {
            throw new IllegalArgumentException("measureColumns are empty!");
        }
        this.measures = parameter.split(",");
        this.trim(this.measures);
        if (this.xAxises == null && this.yAxises == null) {
            throw new IllegalArgumentException("xAxisColumns and yAxisColumns are both empty!");
        }
        this.nameConflictValidate();
    }

    protected void trim(String[] columns) {
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = columns[i].trim();
        }
    }

    protected void nameConflictValidate() {
        HashSet<String> columnNameSet = new HashSet<String>();
        if (this.xAxises != null) {
            this.fillNameSet(this.xAxises, columnNameSet);
        }
        if (this.yAxises != null) {
            this.fillNameSet(this.yAxises, columnNameSet);
        }
        this.fillNameSet(this.measures, columnNameSet);
    }

    protected void fillNameSet(String[] columnNames, Set<String> columnNameSet) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNameSet.add(columnNames[i])) continue;
            throw new IllegalArgumentException(StringFormater.format((String)"Column named '{}' duplicated!", (Object[])new Object[]{columnNames[i]}));
        }
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        this.initializeColumnIndexes(recordSet, columns);
        RecordSetMetadata recordSetMetadata = this.buildRecordSetMetadata(recordSet);
        return this.buildRecordSet(recordSet, recordSetMetadata);
    }

    protected void initializeColumnIndexes(RecordSet recordSet, Columns columns) {
        this.checkGroup(recordSet);
        this.initializeXAxisColumnIndexes(recordSet);
        this.initializeYAxisColumnIndexes(recordSet);
        this.initializeMeasureColumnIndexes(recordSet, columns);
    }

    protected void checkGroup(RecordSet recordSet) {
        RecordSetDefinition recordSetDefinition = recordSet.getRecordSetDefinition();
        this.hasGroup = recordSetDefinition.getGroupColumns().size() != 0;
    }

    protected void initializeXAxisColumnIndexes(RecordSet recordSet) {
        if (this.xAxises == null) {
            return;
        }
        RecordSetDefinition recordSetDefinition = recordSet.getRecordSetDefinition();
        this.xAxisIndexes = new int[this.xAxises.length];
        for (int i = 0; i < this.xAxises.length; ++i) {
            this.xAxisIndexes[i] = recordSetDefinition.getColumnIndex(this.xAxises[i]);
            if (this.xAxisIndexes[i] == -1) {
                throw new IllegalArgumentException(StringFormater.format((String)"There is no column named '{}' in record set!", (Object[])new Object[]{this.xAxises[i]}));
            }
            if (!this.hasGroup || recordSetDefinition.isGroupColumn(this.xAxises[i])) continue;
            throw new IllegalArgumentException(StringFormater.format((String)"Column named '{}' isn't a group column!", (Object[])new Object[]{this.xAxises[i]}));
        }
    }

    protected void initializeYAxisColumnIndexes(RecordSet recordSet) {
        if (this.yAxises == null) {
            return;
        }
        RecordSetDefinition recordSetDefinition = recordSet.getRecordSetDefinition();
        this.yAxisIndexes = new int[this.yAxises.length];
        for (int i = 0; i < this.yAxises.length; ++i) {
            this.yAxisIndexes[i] = recordSetDefinition.getColumnIndex(this.yAxises[i]);
            if (this.yAxisIndexes[i] == -1) {
                throw new IllegalArgumentException(StringFormater.format((String)"There is no column named '{}' in record set!", (Object[])new Object[]{this.yAxises[i]}));
            }
            if (!this.hasGroup || recordSetDefinition.isGroupColumn(this.yAxises[i])) continue;
            throw new IllegalArgumentException(StringFormater.format((String)"Column named '{}' isn't a group column!", (Object[])new Object[]{this.yAxises[i]}));
        }
    }

    protected void initializeMeasureColumnIndexes(RecordSet recordSet, Columns columns) {
        if (this.measures == null) {
            return;
        }
        RecordSetDefinition recordSetDefinition = recordSet.getRecordSetDefinition();
        this.measureMethods = new String[this.measures.length];
        this.measureIndexes = new int[this.measures.length];
        for (int i = 0; i < this.measures.length; ++i) {
            this.measureIndexes[i] = recordSetDefinition.getColumnIndex(this.measures[i]);
            if (this.measureIndexes[i] == -1) {
                throw new IllegalArgumentException(StringFormater.format((String)"There is no column named '{}' in record set!", (Object[])new Object[]{this.measures[i]}));
            }
            if (!this.hasGroup) continue;
            if (recordSetDefinition.isGroupColumn(this.measures[i])) {
                throw new IllegalArgumentException(StringFormater.format((String)"Column named '{}' is a group column!", (Object[])new Object[]{this.measures[i]}));
            }
            Column column = columns.getColumns().get(this.measureIndexes[i]);
            this.measureMethods[i] = column.getOperand().getName();
        }
    }

    protected RecordSetMetadata buildRecordSetMetadata(RecordSet recordSet) {
        LinkedList<ColumnDefinition> columns = new LinkedList<ColumnDefinition>();
        HashSet<String> nameSet = new HashSet<String>();
        ColumnMetadata column = new ColumnMetadata(COLUMN_YAXIS, COLUMN_YAXIS);
        columns.add((ColumnDefinition)column);
        for (int i = 0; i < recordSet.getRecordsCount(); ++i) {
            String xAxis = this.buildAxisColumnName(this.xAxisIndexes, recordSet.getRecord(i));
            String[] measureNames = this.buildMeasureColumnNames(xAxis);
            for (int j = 0; j < measureNames.length; ++j) {
                if (!nameSet.add(measureNames[j])) {
                    if (this.yAxises != null) continue;
                    throw new IllegalArgumentException(StringFormater.format((String)"Measure column named '{}' duplicated!", (Object[])new Object[]{measureNames[i]}));
                }
                column = new ColumnMetadata(measureNames[j], measureNames[j]);
                columns.add((ColumnDefinition)column);
            }
            if (this.xAxises == null) break;
        }
        return new RecordSetMetadata(columns, null);
    }

    protected RecordSet buildRecordSet(RecordSet recordSet, RecordSetMetadata recordSetMetadata) {
        Map<String, Integer> xAxisPosMap = this.buildXAxisPosMap(recordSetMetadata);
        HashMap<String, Integer> yAxisPosMap = new HashMap<String, Integer>();
        LinkedList<Object[]> records = new LinkedList<Object[]>();
        int yIndex = 0;
        for (int i = 0; i < recordSet.getRecordsCount(); ++i) {
            Object[] record;
            Object[] srcRecord = recordSet.getRecord(i);
            String yAxisColumnName = this.buildAxisColumnName(this.yAxisIndexes, srcRecord);
            Integer pos = (Integer)yAxisPosMap.get(yAxisColumnName);
            if (pos == null) {
                record = new Object[xAxisPosMap.size()];
                record[0] = yAxisColumnName;
                records.add(record);
                yAxisPosMap.put(yAxisColumnName, yIndex++);
            } else {
                record = (Object[])records.get(pos);
            }
            this.fillMeasures(record, xAxisPosMap, srcRecord);
        }
        return new RecordSetImpl(recordSetMetadata, recordSet.getStart(), recordSet.getEnd(), records);
    }

    protected String buildAxisColumnName(int[] axisIndexes, Object[] record) {
        if (axisIndexes == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < axisIndexes.length; ++i) {
            if (i != 0) {
                sbuf.append('.');
            }
            sbuf.append(record[axisIndexes[i]]);
        }
        return sbuf.toString();
    }

    protected String[] buildMeasureColumnNames(String axisColumnName) {
        String[] names = new String[this.measures.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = axisColumnName != null ? StringFormater.format((String)"{}.[{}:{}]", (Object[])new Object[]{axisColumnName, this.measures[i], this.measureMethods[i] == null ? "" : this.measureMethods[i]}) : StringFormater.format((String)"[{}:{}]", (Object[])new Object[]{this.measures[i], this.measureMethods[i] == null ? "" : this.measureMethods[i]});
        }
        return names;
    }

    protected Map<String, Integer> buildXAxisPosMap(RecordSetMetadata recordSetMetadata) {
        HashMap<String, Integer> xAxisPosMap = new HashMap<String, Integer>();
        List<ColumnDefinition> columns = recordSetMetadata.getColumns();
        int i = 0;
        for (ColumnDefinition columnDefinition : columns) {
            xAxisPosMap.put(columnDefinition.getName(), i++);
        }
        return xAxisPosMap;
    }

    protected void fillMeasures(Object[] targetRecord, Map<String, Integer> xAxisPosMap, Object[] sourceRecord) {
        String xAxisColumnName = this.buildAxisColumnName(this.xAxisIndexes, sourceRecord);
        String[] measureColumnNames = this.buildMeasureColumnNames(xAxisColumnName);
        for (int i = 0; i < measureColumnNames.length; ++i) {
            Integer pos = xAxisPosMap.get(measureColumnNames[i]);
            if (pos == null) {
                throw new IllegalArgumentException(StringFormater.format((String)"There is no column named '{}'", (Object[])new Object[]{measureColumnNames[i]}));
            }
            targetRecord[pos.intValue()] = sourceRecord[this.measureIndexes[i]];
        }
    }
}

