/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function.decorator;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.EntityMapImpl;
import org.datayoo.moql.Operand;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.operand.function.AggregationFunction;
import org.datayoo.moql.operand.function.decorator.DecorateFunction;
import org.datayoo.moql.operand.function.factory.FunctionFactory;
import org.datayoo.moql.operand.function.factory.FunctionFactoryImpl;
import org.datayoo.moql.operand.variable.SingleVariable;

public class OtherCaculation
extends DecorateFunction {
    public static final String FUNCTION_NAME = "otherCaculation";
    protected OtherAlias[] otherAliases;
    protected int[] groupIndexes;
    protected OtherRecord[] otherRecords;
    protected FunctionFactory functionFactory;
    protected boolean firstTime = true;

    public OtherCaculation(List<Operand> parameters) {
        super(FUNCTION_NAME, parameters.size(), parameters);
        this.initializeOtherAlias();
        this.groupIndexes = new int[this.otherAliases.length];
        this.otherRecords = new OtherRecord[this.otherAliases.length];
        this.functionFactory = FunctionFactoryImpl.createFunctionFactory();
    }

    protected void initializeOtherAlias() {
        this.otherAliases = new OtherAlias[this.parameters.size()];
        int i = 0;
        OtherAlias lastOtherAlias = null;
        for (Operand parameter : this.parameters) {
            Object obj = parameter.operate(null);
            String value = null;
            if (obj != null) {
                value = obj.toString();
            }
            if (value != null) {
                String[] kv = value.split(":");
                if (kv.length != 2) {
                    throw new IllegalArgumentException("The parameter's format should be 'alias:limit'!");
                }
                kv[0] = kv[0].trim();
                kv[1] = kv[1].trim();
                if (kv[0].length() == 0 || kv[1].length() == 0) {
                    throw new IllegalArgumentException("The parameter's format should be 'alias:limit'!");
                }
                this.otherAliases[i] = new OtherAlias(kv[0], Integer.valueOf(kv[1]));
                lastOtherAlias = this.otherAliases[i];
            }
            ++i;
        }
        if (lastOtherAlias == null) {
            throw new IllegalArgumentException("Other alias is empty!");
        }
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        if (recordSet == null) {
            return null;
        }
        this.initialize(recordSet, columns);
        return this.caculate(recordSet);
    }

    protected void initialize(RecordSet recordSet, Columns columns) {
        RecordSetDefinition recordSetDefinition = recordSet.getRecordSetDefinition();
        this.initializeGroupIndexes(recordSetDefinition);
        this.initializeOtherRecords(recordSetDefinition, columns);
    }

    protected void initializeGroupIndexes(RecordSetDefinition recordSetDefinition) {
        List<ColumnDefinition> columnDefinitions = recordSetDefinition.getGroupColumns();
        if (columnDefinitions.size() == 0 && this.otherAliases.length != 1) {
            throw new IllegalArgumentException("The count of aliases should be one when the record set has no group!");
        }
        if (columnDefinitions.size() != this.otherAliases.length) {
            throw new IllegalArgumentException("The count of aliases and the columnes in group caculation is not match!");
        }
        int i = 0;
        for (ColumnDefinition column : columnDefinitions) {
            this.groupIndexes[i++] = recordSetDefinition.getColumnIndex(column.getName());
        }
    }

    protected void initializeOtherRecords(RecordSetDefinition recordSetDefinition, Columns columns) {
        for (int i = 0; i < this.otherRecords.length; ++i) {
            if (this.otherAliases[i] == null) continue;
            this.otherRecords[i] = new OtherRecord(i + 1, columns.getColumns().size(), this.otherAliases[i].limit);
            this.otherRecords[i].initializeOperands(recordSetDefinition, columns);
        }
    }

    protected RecordSet caculate(RecordSet recordSet) {
        LinkedList<Object[]> records = new LinkedList<Object[]>();
        int index = 0;
        for (Object[] record : recordSet.getRecords()) {
            if (!this.firstTime) {
                index = this.whichOtherRecordGroupChanged(record);
                if (index + 1 < this.otherRecords.length) {
                    this.buildRecords(index + 1, records);
                }
                this.intitializeOtherRecordGroups(index, record);
            } else {
                this.intitializeOtherRecordGroups(0, record);
                this.firstTime = false;
            }
            if (this.caculate(record, recordSet)) continue;
            records.add(record);
        }
        this.buildRecords(0, records);
        return new RecordSetImpl(recordSet.getRecordSetDefinition(), recordSet.getStart(), recordSet.getEnd(), records);
    }

    protected void intitializeOtherRecordGroups(int startIndex, Object[] record) {
        for (int i = startIndex; i < this.otherRecords.length; ++i) {
            if (this.otherRecords[i] == null) continue;
            this.otherRecords[i].initializeGroups(record);
        }
    }

    protected int whichOtherRecordGroupChanged(Object[] record) {
        for (int i = 0; i < this.otherRecords.length; ++i) {
            if (this.otherRecords[i] == null || !this.otherRecords[i].isGroupChanged(record)) continue;
            return i;
        }
        return 0;
    }

    protected boolean caculate(Object[] record, RecordSet recordSet) {
        EntityMapImpl entityMap = new EntityMapImpl(recordSet.toMap(record));
        for (int i = 0; i < this.otherRecords.length; ++i) {
            if (this.otherRecords[i] == null || !this.otherRecords[i].caculate(entityMap)) continue;
            return true;
        }
        return false;
    }

    protected void buildRecords(int index, List<Object[]> records) {
        for (int i = this.otherRecords.length - 1; i >= index; --i) {
            if (this.otherRecords[i] == null) continue;
            Object[] record = this.otherRecords[i].buildRecordAndClear();
            records.add(record);
        }
    }

    protected class OtherRecord {
        protected Object[] groups;
        protected Operand[] operands;
        protected int limit = 0;
        protected int offset = 0;

        public OtherRecord(int groupSize, int operandSize, int limit) {
            this.groups = new Object[groupSize];
            this.operands = new Operand[operandSize];
            this.limit = limit;
        }

        public void initializeGroups(Object[] record) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = record[OtherCaculation.this.groupIndexes[i]];
            }
            ++this.offset;
        }

        public boolean isGroupChanged(Object[] record) {
            for (int i = 0; i < this.groups.length; ++i) {
                if (ObjectUtils.equals((Object)this.groups[i], (Object)record[OtherCaculation.this.groupIndexes[i]])) continue;
                return true;
            }
            return false;
        }

        public void initializeOperands(RecordSetDefinition recordSetDefinition, Columns columns) {
            int i = 0;
            for (Column column : columns.getColumns()) {
                String columnName = column.getColumnMetadata().getName();
                if (!recordSetDefinition.isGroupColumn(columnName)) {
                    this.operands[i++] = this.createOperand(columnName, column.getOperand());
                    continue;
                }
                this.operands[i++] = null;
            }
        }

        protected Operand createOperand(String name, Operand operand) {
            if (!(operand instanceof AggregationFunction)) {
                return null;
            }
            AggregationFunction function = (AggregationFunction)operand;
            SingleVariable parameter = new SingleVariable(name);
            LinkedList<Operand> parameters = new LinkedList<Operand>();
            parameters.add(parameter);
            String functionName = function.getName();
            if (functionName.equals("count")) {
                functionName = "sum";
            }
            return OtherCaculation.this.functionFactory.createFunction(functionName, parameters);
        }

        public boolean caculate(EntityMap entityMap) {
            if (this.offset <= this.limit) {
                return false;
            }
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i] == null) continue;
                this.operands[i].operate(entityMap);
            }
            return true;
        }

        public Object[] buildRecordAndClear() {
            Object[] record = new Object[this.operands.length];
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i] == null) continue;
                record[i] = this.operands[i].getValue();
                this.operands[i].clear();
            }
            this.fillGroups(record);
            return record;
        }

        protected void fillGroups(Object[] record) {
            int i;
            if (this.groups != null) {
                for (i = 0; i < this.groups.length - 1; ++i) {
                    record[OtherCaculation.this.groupIndexes[i]] = this.groups[i];
                }
            }
            if (i < OtherCaculation.this.otherAliases.length) {
                record[OtherCaculation.this.groupIndexes[i]] = OtherCaculation.this.otherAliases[i].alias;
                ++i;
            }
            while (i < OtherCaculation.this.otherAliases.length) {
                record[OtherCaculation.this.groupIndexes[i]] = "-";
                ++i;
            }
        }
    }

    protected class OtherAlias {
        protected String alias;
        protected int limit;

        public OtherAlias(String alias, int limit) {
            this.alias = alias;
            this.limit = limit;
        }
    }
}

