/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function.decorator;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.EntityMapImpl;
import org.datayoo.moql.Operand;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.operand.function.AggregationFunction;
import org.datayoo.moql.operand.function.decorator.DecorateFunction;
import org.datayoo.moql.operand.function.factory.FunctionFactory;
import org.datayoo.moql.operand.function.factory.FunctionFactoryImpl;
import org.datayoo.moql.operand.variable.SingleVariable;

public class TotalCaculation
extends DecorateFunction {
    public static final String FUNCTION_NAME = "totalCaculation";
    protected String[] totalAliases;
    protected int[] groupIndexes;
    protected TotalRecord[] totalRecords;
    protected FunctionFactory functionFactory;
    protected boolean firstTime = true;

    public TotalCaculation(List<Operand> parameters) {
        super(FUNCTION_NAME, parameters.size(), parameters);
        this.initializeTotalAlias();
        this.groupIndexes = new int[this.totalAliases.length];
        this.totalRecords = new TotalRecord[this.totalAliases.length];
        this.functionFactory = FunctionFactoryImpl.createFunctionFactory();
    }

    protected void initializeTotalAlias() {
        this.totalAliases = new String[this.parameters.size()];
        int i = 0;
        int length = 0;
        for (Operand parameter : this.parameters) {
            Object obj = parameter.operate(null);
            if (obj != null) {
                this.totalAliases[i] = obj.toString();
            }
            if (this.totalAliases[i] != null) {
                this.totalAliases[i].trim();
                if (this.totalAliases[i].length() == 0) {
                    throw new IllegalArgumentException("Parameter couldn't be empty!");
                }
                if (this.totalAliases[i].length() > length) {
                    length = this.totalAliases[i].length();
                }
            }
            ++i;
        }
        if (length == 0) {
            throw new IllegalArgumentException("Total alias is empty!");
        }
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        if (recordSet == null) {
            return null;
        }
        this.initialize(recordSet, columns);
        return this.caculate(recordSet);
    }

    protected void initialize(RecordSet recordSet, Columns columns) {
        RecordSetDefinition recordSetDefinition = recordSet.getRecordSetDefinition();
        this.initializeGroupIndexes(recordSetDefinition);
        this.initializeTotalRecords(recordSetDefinition, columns);
    }

    protected void initializeGroupIndexes(RecordSetDefinition recordSetDefinition) {
        List<ColumnDefinition> columnDefinitions = recordSetDefinition.getGroupColumns();
        if (columnDefinitions.size() == 0 && this.totalAliases.length != 1) {
            throw new IllegalArgumentException("The count of aliases should be one when the record set has no group!");
        }
        if (columnDefinitions.size() != this.totalAliases.length) {
            throw new IllegalArgumentException("The count of aliases and the columnes in group caculation is not match!");
        }
        int i = 0;
        for (ColumnDefinition column : columnDefinitions) {
            this.groupIndexes[i++] = recordSetDefinition.getColumnIndex(column.getName());
        }
    }

    protected void initializeTotalRecords(RecordSetDefinition recordSetDefinition, Columns columns) {
        for (int i = 0; i < this.totalRecords.length; ++i) {
            if (this.totalAliases[i] == null) continue;
            this.totalRecords[i] = new TotalRecord(i, columns.getColumns().size());
            this.totalRecords[i].initializeOperands(recordSetDefinition, columns);
        }
    }

    protected RecordSet caculate(RecordSet recordSet) {
        LinkedList<Object[]> records = new LinkedList<Object[]>();
        int index = 0;
        for (Object[] record : recordSet.getRecords()) {
            if (!this.firstTime) {
                index = this.whichTotalRecordGroupChanged(record);
                if (index != 0) {
                    this.buildRecords(index, records);
                }
                this.intitializeTotalRecordGroups(index, record);
            } else {
                this.intitializeTotalRecordGroups(1, record);
                this.firstTime = false;
            }
            this.caculate(record, recordSet);
            records.add(record);
        }
        this.buildRecords(0, records);
        return new RecordSetImpl(recordSet.getRecordSetDefinition(), recordSet.getStart(), recordSet.getEnd(), records);
    }

    protected void intitializeTotalRecordGroups(int startIndex, Object[] record) {
        for (int i = startIndex = startIndex > 0 ? startIndex : 1; i < this.totalRecords.length; ++i) {
            if (this.totalRecords[i] == null) continue;
            this.totalRecords[i].initializeGroups(record);
        }
    }

    protected int whichTotalRecordGroupChanged(Object[] record) {
        for (int i = 1; i < this.totalRecords.length; ++i) {
            if (this.totalRecords[i] == null || !this.totalRecords[i].isGroupChanged(record)) continue;
            return i;
        }
        return 0;
    }

    protected void caculate(Object[] record, RecordSet recordSet) {
        EntityMapImpl entityMap = new EntityMapImpl(recordSet.toMap(record));
        for (int i = 0; i < this.totalRecords.length; ++i) {
            if (this.totalRecords[i] == null) continue;
            this.totalRecords[i].caculate(entityMap);
        }
    }

    protected void buildRecords(int index, List<Object[]> records) {
        for (int i = this.totalRecords.length - 1; i >= index; --i) {
            if (this.totalRecords[i] == null) continue;
            Object[] record = this.totalRecords[i].buildRecordAndClear();
            records.add(record);
        }
    }

    protected class TotalRecord {
        protected Object[] groups;
        protected Operand[] operands;

        public TotalRecord(int groupSize, int operandSize) {
            if (groupSize != 0) {
                this.groups = new Object[groupSize];
            }
            this.operands = new Operand[operandSize];
        }

        public void initializeGroups(Object[] record) {
            if (this.groups != null) {
                for (int i = 0; i < this.groups.length; ++i) {
                    this.groups[i] = record[TotalCaculation.this.groupIndexes[i]];
                }
            }
        }

        public boolean isGroupChanged(Object[] record) {
            if (this.groups != null) {
                for (int i = 0; i < this.groups.length; ++i) {
                    if (ObjectUtils.equals((Object)this.groups[i], (Object)record[TotalCaculation.this.groupIndexes[i]])) continue;
                    return true;
                }
            }
            return false;
        }

        public void initializeOperands(RecordSetDefinition recordSetDefinition, Columns columns) {
            int i = 0;
            for (Column column : columns.getColumns()) {
                String columnName = column.getColumnMetadata().getName();
                if (!recordSetDefinition.isGroupColumn(columnName)) {
                    this.operands[i++] = this.createOperand(columnName, column.getOperand());
                    continue;
                }
                this.operands[i++] = null;
            }
        }

        protected Operand createOperand(String name, Operand operand) {
            if (!(operand instanceof AggregationFunction)) {
                return null;
            }
            AggregationFunction function = (AggregationFunction)operand;
            SingleVariable parameter = new SingleVariable(name);
            LinkedList<Operand> parameters = new LinkedList<Operand>();
            parameters.add(parameter);
            String functionName = function.getName();
            if (functionName.equals("count")) {
                functionName = "sum";
            }
            return TotalCaculation.this.functionFactory.createFunction(functionName, parameters);
        }

        public void caculate(EntityMap entityMap) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i] == null) continue;
                this.operands[i].operate(entityMap);
            }
        }

        public Object[] buildRecordAndClear() {
            Object[] record = new Object[this.operands.length];
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i] == null) continue;
                record[i] = this.operands[i].getValue();
                this.operands[i].clear();
            }
            this.fillGroups(record);
            return record;
        }

        protected void fillGroups(Object[] record) {
            int i;
            if (this.groups != null) {
                for (i = 0; i < this.groups.length; ++i) {
                    record[TotalCaculation.this.groupIndexes[i]] = this.groups[i];
                }
            }
            if (i < TotalCaculation.this.totalAliases.length) {
                record[TotalCaculation.this.groupIndexes[i]] = TotalCaculation.this.totalAliases[i];
                ++i;
            }
            while (i < TotalCaculation.this.totalAliases.length) {
                record[TotalCaculation.this.groupIndexes[i]] = "-";
                ++i;
            }
        }
    }
}

