/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Position;
import org.geolatte.geom.PositionFactory;
import org.geolatte.geom.PositionSequenceBuilder;

abstract class AbstractPositionSequenceBuilder<P extends Position>
implements PositionSequenceBuilder<P> {
    protected final PositionFactory<P> factory;
    protected final double[] coords;
    private int numAdded = 0;

    public AbstractPositionSequenceBuilder(PositionFactory<P> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Require a non-null Coordinate reference system.");
        }
        this.factory = factory;
        this.coords = new double[factory.getCoordinateDimension()];
    }

    @Override
    public PositionSequenceBuilder<P> add(double ... coordinates) {
        if (coordinates.length < this.factory.getCoordinateDimension()) {
            throw new IllegalArgumentException(String.format("Parameter must be array of length %d", this.factory.getCoordinateDimension()));
        }
        for (int i = 0; i < this.factory.getCoordinateDimension(); ++i) {
            this.addCoordinate(coordinates[i]);
        }
        ++this.numAdded;
        return this;
    }

    @Override
    public PositionSequenceBuilder<P> add(P pos) {
        ((Position)pos).toArray(this.coords);
        for (double coord : this.coords) {
            this.addCoordinate(coord);
        }
        ++this.numAdded;
        return this;
    }

    @Override
    public int getNumAdded() {
        return this.numAdded;
    }

    protected abstract void addCoordinate(double var1);
}

