/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.geolatte.geom.Box;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Complex;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.GeometryEquality;
import org.geolatte.geom.GeometryPositionEquality;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LLAPositionVisitor;
import org.geolatte.geom.NestedPositionSequence;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.PositionVisitor;
import org.geolatte.geom.Positions;
import org.geolatte.geom.Simple;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;

public abstract class Geometry<P extends Position>
implements Serializable {
    private static final long serialVersionUID = 6884205871950410216L;
    private static final GeometryEquality geomEq = new GeometryPositionEquality();
    private final PositionSequence<P> positions;
    private final CoordinateReferenceSystem<P> crs;

    public static <Q extends Position> Geometry<Q> forceToCrs(Geometry<?> geometry, CoordinateReferenceSystem<Q> crs, double coordinateValue) {
        if (crs == null || geometry == null) {
            return geometry;
        }
        if (crs.equals(geometry.getCoordinateReferenceSystem())) {
            return geometry;
        }
        if (geometry instanceof Simple) {
            Simple simple = (Simple)((Object)geometry);
            PositionSequence<Q> positions = Positions.copy(geometry.getPositions(), crs.getPositionClass(), coordinateValue);
            return Geometries.mkGeometry(simple.getClass(), positions, crs);
        }
        Complex complex = (Complex)((Object)geometry);
        if (complex.getNumGeometries() == 0) {
            return Geometries.mkGeometry(complex.getClass(), crs);
        }
        Geometry[] targetParts = (Geometry[])Array.newInstance(complex.getComponentType(), complex.getNumGeometries());
        int idx = 0;
        for (Geometry part : complex) {
            targetParts[idx++] = Geometry.forceToCrs(part, crs);
        }
        return Geometries.mkGeometry(complex.getClass(), targetParts);
    }

    public static <Q extends Position> Geometry<Q> forceToCrs(Geometry<?> geometry, CoordinateReferenceSystem<Q> crs) {
        return Geometry.forceToCrs(geometry, crs, Double.NaN);
    }

    protected Geometry(CoordinateReferenceSystem<P> crs) {
        if (crs == null) {
            throw new IllegalArgumentException("Received null CRS argument");
        }
        this.crs = crs;
        this.positions = PositionSequenceBuilders.fixedSized(0, crs.getPositionClass()).toPositionSequence();
    }

    protected Geometry(PositionSequence<P> positions, CoordinateReferenceSystem<P> crs) {
        if (crs == null) {
            throw new IllegalArgumentException("Received null CRS argument");
        }
        if (positions == null) {
            throw new IllegalArgumentException("Null Positions argument not allowd.");
        }
        this.crs = crs;
        this.positions = positions;
    }

    protected static <T extends Position> PositionSequence<T> nestPositionSequences(Geometry<T>[] geometries) {
        if (geometries == null || geometries.length == 0) {
            return new NestedPositionSequence(new PositionSequence[0]);
        }
        PositionSequence[] sequences = new PositionSequence[geometries.length];
        int i = 0;
        for (Geometry<T> g : geometries) {
            sequences[i++] = g.getPositions();
        }
        return new NestedPositionSequence(sequences);
    }

    protected static <T extends Position> CoordinateReferenceSystem<T> getCrs(Geometry<T>[] geometries) {
        if (geometries == null || geometries.length == 0) {
            return CrsRegistry.getCoordinateReferenceSystemForEPSG(-1, CoordinateReferenceSystems.PROJECTED_2D_METER);
        }
        return geometries[0].getCoordinateReferenceSystem();
    }

    public int getCoordinateDimension() {
        return this.getPositions().getCoordinateDimension();
    }

    public CoordinateReferenceSystem<P> getCoordinateReferenceSystem() {
        return this.crs;
    }

    public int getSRID() {
        return this.getCoordinateReferenceSystem().getCrsId().getCode();
    }

    public boolean isEmpty() {
        return this.getPositions().isEmpty();
    }

    public int getNumPositions() {
        return this.getPositions().size();
    }

    public Class<P> getPositionClass() {
        return !this.getPositions().isEmpty() ? this.getPositions().getPositionClass() : this.crs.getPositionClass();
    }

    public P getPositionN(int index) {
        if (index >= this.getPositions().size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPositions().getPositionN(index);
    }

    protected <Q extends Position> void checkCast(Class<Q> castToType) {
        if (!castToType.isAssignableFrom(this.getPositionClass())) {
            throw new ClassCastException(String.format("Can't cast a %s to a %s", this.getPositionClass().getName(), castToType.getName()));
        }
    }

    public <Q extends Position> Geometry<Q> as(Class<Q> castToType) {
        this.checkCast(castToType);
        return this;
    }

    public PositionSequence<P> getPositions() {
        return this.positions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Geometry.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        if (!this.getPositionClass().equals(((Geometry)o).getPositionClass())) {
            return false;
        }
        Geometry otherGeometry = (Geometry)o;
        return geomEq.equals(this, otherGeometry);
    }

    public Envelope<P> getEnvelope() {
        if (this.isEmpty()) {
            return new Envelope<P>(this.getCoordinateReferenceSystem());
        }
        PositionSequence<P> positions = this.getPositions();
        EnvelopeVisitor<P> visitor = new EnvelopeVisitor<P>(this.getCoordinateReferenceSystem());
        positions.accept(visitor);
        return visitor.result();
    }

    public Box<P> getBoundingBox() {
        if (this.isEmpty()) {
            return Box.mkEmpty(this.crs);
        }
        BoxVisitor<P> bv = new BoxVisitor<P>(this.crs);
        this.getPositions().accept(bv);
        return bv.build();
    }

    public boolean hasM() {
        return this.getCoordinateReferenceSystem().hasM();
    }

    public boolean hasZ() {
        return this.getCoordinateReferenceSystem().hasZ();
    }

    public int hashCode() {
        int result = this.getGeometryType().hashCode();
        result = 31 * result + this.getPositions().hashCode();
        return result;
    }

    public abstract GeometryType getGeometryType();

    public String toString() {
        return Wkt.toWkt(this);
    }

    public abstract int getDimension();

    public <Q extends Position> Geometry<Q> toCrs(CoordinateReferenceSystem<Q> crs, double defaultCoordinateValue) {
        return Geometry.forceToCrs(this, crs, defaultCoordinateValue);
    }

    public abstract void accept(GeometryVisitor<P> var1);

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("Require WKB serialization");
    }

    protected Object writeReplace() throws ObjectStreamException {
        WkbEncoder encoder = Wkb.newEncoder(Wkb.Dialect.POSTGIS_EWKB_2);
        ByteBuffer buffer = encoder.encode(this);
        return new SerializationProxy(buffer);
    }

    private static class BoxVisitor<P extends Position>
    implements LLAPositionVisitor {
        private double[] lowerLeft;
        private double[] upperRight;
        private final CoordinateReferenceSystem<P> crs;

        BoxVisitor(CoordinateReferenceSystem<P> crs) {
            this.crs = crs;
            this.lowerLeft = new double[crs.getCoordinateDimension()];
            Arrays.fill(this.lowerLeft, Double.MAX_VALUE);
            this.upperRight = new double[crs.getCoordinateDimension()];
            Arrays.fill(this.upperRight, -1.7976931348623157E308);
        }

        @Override
        public void visit(double[] coordinate) {
            for (int i = 0; i < coordinate.length; ++i) {
                this.lowerLeft[i] = Math.min(this.lowerLeft[i], coordinate[i]);
                this.upperRight[i] = Math.max(this.upperRight[i], coordinate[i]);
            }
        }

        Box<P> build() {
            return new Box<P>(Positions.mkPosition(this.crs, this.lowerLeft), Positions.mkPosition(this.crs, this.upperRight), this.crs);
        }
    }

    private static class EnvelopeVisitor<P extends Position>
    implements PositionVisitor<P> {
        double[] coordinates;
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        final CoordinateReferenceSystem<P> crs;

        EnvelopeVisitor(CoordinateReferenceSystem<P> crs) {
            this.crs = crs;
            this.coordinates = new double[crs.getCoordinateDimension()];
        }

        @Override
        public void visit(P position) {
            ((Position)position).toArray(this.coordinates);
            this.xMin = Math.min(this.xMin, this.coordinates[0]);
            this.xMax = Math.max(this.xMax, this.coordinates[0]);
            this.yMin = Math.min(this.yMin, this.coordinates[1]);
            this.yMax = Math.max(this.yMax, this.coordinates[1]);
        }

        public Envelope<P> result() {
            return new Envelope<P>(this.xMin, this.yMin, this.xMax, this.yMax, this.crs);
        }
    }

    private static class SerializationProxy
    implements Serializable {
        private final byte[] buffer;

        SerializationProxy(ByteBuffer buffer) {
            this.buffer = buffer.toByteArray();
        }

        private Object readResolve() throws ObjectStreamException {
            return Wkb.fromWkb(ByteBuffer.from(this.buffer));
        }
    }
}

