/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.geolatte.geom.C2D;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.SimpleTokenizer;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktDialect;
import org.geolatte.geom.codec.support.CollectionGeometryBuilder;
import org.geolatte.geom.codec.support.DecodeException;
import org.geolatte.geom.codec.support.GeometryBuilder;
import org.geolatte.geom.codec.support.Holder;
import org.geolatte.geom.codec.support.LinearPositionsHolder;
import org.geolatte.geom.codec.support.LinearPositionsListHolder;
import org.geolatte.geom.codec.support.PointHolder;
import org.geolatte.geom.codec.support.PolygonListHolder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;

class BaseWktParser<P extends Position> {
    private static final CoordinateReferenceSystem<C2D> DEFAULT_CRS = CoordinateReferenceSystems.PROJECTED_2D_METER;
    private static final Pattern EMPTY_PATTERN = Pattern.compile("empty", 2);
    private final WktDialect dialect;
    private final CoordinateReferenceSystem<P> overrideCrs;
    private CoordinateReferenceSystem<?> matchedSrid;
    SimpleTokenizer tokenizer;
    GeometryType type;
    GeometryBuilder builder;
    boolean hasMMark = false;
    boolean hasZMark = false;

    BaseWktParser(WktDialect wktDialect, String wkt, CoordinateReferenceSystem<P> crs) {
        this.dialect = wktDialect;
        this.tokenizer = new SimpleTokenizer(wkt);
        this.overrideCrs = crs;
    }

    Geometry<P> parse() {
        this.matchesOptionalSrid();
        this.builder = this.matchesGeometryTaggedText();
        CoordinateReferenceSystem<P> geomCrs = this.selectCoordinateReferenceSystem();
        try {
            return this.builder.createGeometry(geomCrs);
        }
        catch (DecodeException e) {
            throw new WktDecodeException("Failure in decoding Wkt", e);
        }
    }

    protected GeometryBuilder matchesGeometryTaggedText() {
        this.matchesGeometryKeyword();
        GeometryBuilder builder = GeometryBuilder.create(this.type);
        this.matchesOptionalZMMarkers();
        this.matchesTaggedText(builder);
        return builder;
    }

    protected CoordinateReferenceSystem<P> selectCoordinateReferenceSystem() {
        if (this.overrideCrs != null) {
            return this.overrideCrs;
        }
        CoordinateReferenceSystem<C2D> baseCrs = this.matchedSrid != null ? this.matchedSrid : DEFAULT_CRS;
        return this.widenCrsToCoordinateDimension(baseCrs);
    }

    protected CoordinateReferenceSystem<?> widenCrsToCoordinateDimension(CoordinateReferenceSystem<?> crs) {
        if (this.builder.isEmpty()) {
            return CoordinateReferenceSystems.adjustTo(crs, this.hasZMark, this.hasMMark);
        }
        return CoordinateReferenceSystems.adjustTo(crs, this.builder.getCoordinateDimension(), this.hasMMark);
    }

    protected void matchesOptionalSrid() {
    }

    protected void setMatchedSrid(CoordinateReferenceSystem<?> crs) {
        this.matchedSrid = crs;
    }

    protected void matchesGeometryKeyword() {
        for (Map.Entry<GeometryType, Pattern> entry : this.dialect.geometryTypePatternMap().entrySet()) {
            if (!this.tokenizer.matchPattern(entry.getValue())) continue;
            this.type = entry.getKey();
            return;
        }
        throw new WktDecodeException("Expected geometryKeyword starting at position: " + this.tokenizer.currentPos());
    }

    protected void matchesOptionalZMMarkers() {
    }

    protected void matchesTaggedText(GeometryBuilder builder) {
        if (this.tokenizer.matchPattern(EMPTY_PATTERN)) {
            return;
        }
        this.matchesPositionText(builder);
    }

    protected void matchesPositionText(GeometryBuilder builder) {
        switch (this.type) {
            case POINT: {
                builder.setPositions(this.matchesSinglePosition());
                break;
            }
            case LINESTRING: {
                builder.setPositions(this.matchesPositionList());
                break;
            }
            case POLYGON: 
            case MULTILINESTRING: {
                builder.setPositions(this.matchesListOfPositionList());
                break;
            }
            case MULTIPOLYGON: {
                builder.setPositions(this.matchesPolygonList());
                break;
            }
            case MULTIPOINT: {
                builder.setPositions(this.matchesMultiPointList());
                break;
            }
            case GEOMETRYCOLLECTION: {
                this.matchGeometries((CollectionGeometryBuilder)builder);
                break;
            }
            default: {
                throw new WktDecodeException("Unknown geometry type");
            }
        }
    }

    protected Holder matchesMultiPointList() {
        Delimiter d;
        if (!this.tokenizer.matchesOpenList()) {
            throw new WktDecodeException("Expected '(' near position " + this.tokenizer.currentPos());
        }
        LinearPositionsHolder lplh = new LinearPositionsHolder();
        do {
            boolean expectClose = this.matchesOptionalOpenList();
            lplh.push(this.matchesPosition());
            this.expectCloseList(expectClose);
            d = this.matchesDelimiter();
            if (d != Delimiter.NO_DELIM) continue;
            throw new WktDecodeException(String.format("Expected ')' or ',' near %d", this.tokenizer.currentPos()));
        } while (d != Delimiter.CLOSE);
        return lplh;
    }

    protected boolean matchesOptionalOpenList() {
        return this.tokenizer.matchesOpenList();
    }

    protected void expectCloseList(boolean expect) {
        if (expect && !this.tokenizer.matchesCloseList()) {
            throw new WktDecodeException(String.format("Expected ')' or ',' near %d", this.tokenizer.currentPos()));
        }
    }

    protected void matchGeometries(CollectionGeometryBuilder builder) {
        Delimiter d;
        if (!this.tokenizer.matchesOpenList()) {
            throw new WktDecodeException("Expected '(' near position " + this.tokenizer.currentPos());
        }
        do {
            builder.push(this.matchesGeometryTaggedText());
            d = this.matchesDelimiter();
            if (d != Delimiter.NO_DELIM) continue;
            throw new WktDecodeException(String.format("Expected ')' or ',' near %d", this.tokenizer.currentPos()));
        } while (d != Delimiter.CLOSE);
    }

    protected PointHolder matchesPosition() {
        Delimiter d;
        PointHolder pnt = new PointHolder();
        do {
            pnt.push(this.tokenizer.fastReadNumber());
        } while ((d = this.matchesDelimiter()) != Delimiter.CLOSE && d != Delimiter.SEP);
        this.tokenizer.back(1);
        return pnt;
    }

    protected PointHolder matchesSinglePosition() {
        if (!this.tokenizer.matchesOpenList()) {
            throw new WktDecodeException("Expected '(' near position " + this.tokenizer.currentPos());
        }
        PointHolder pnt = this.matchesPosition();
        if (!this.tokenizer.matchesCloseList()) {
            throw new WktDecodeException("Expected ')' near position " + this.tokenizer.currentPos());
        }
        return pnt;
    }

    protected LinearPositionsHolder matchesPositionList() {
        Delimiter d;
        if (!this.tokenizer.matchesOpenList()) {
            throw new WktDecodeException("Expected '(' near position " + this.tokenizer.currentPos());
        }
        LinearPositionsHolder lph = new LinearPositionsHolder();
        do {
            lph.push(this.matchesPosition());
            d = this.matchesDelimiter();
            if (d != Delimiter.NO_DELIM) continue;
            throw new WktDecodeException(String.format("Expected ')' or ',' near %d", this.tokenizer.currentPos()));
        } while (d != Delimiter.CLOSE);
        return lph;
    }

    protected LinearPositionsListHolder matchesListOfPositionList() {
        Delimiter d;
        if (!this.tokenizer.matchesOpenList()) {
            throw new WktDecodeException("Expected '(' near position " + this.tokenizer.currentPos());
        }
        LinearPositionsListHolder lplh = new LinearPositionsListHolder();
        do {
            lplh.push(this.matchesPositionList());
            d = this.matchesDelimiter();
            if (d != Delimiter.NO_DELIM) continue;
            throw new WktDecodeException(String.format("Expected ')' or ',' near %d", this.tokenizer.currentPos()));
        } while (d != Delimiter.CLOSE);
        return lplh;
    }

    protected PolygonListHolder matchesPolygonList() {
        Delimiter d;
        if (!this.tokenizer.matchesOpenList()) {
            throw new WktDecodeException("Expected '(' near position " + this.tokenizer.currentPos());
        }
        PolygonListHolder plh = new PolygonListHolder();
        do {
            plh.push(this.matchesListOfPositionList());
            d = this.matchesDelimiter();
            if (d != Delimiter.NO_DELIM) continue;
            throw new WktDecodeException(String.format("Expected ')' or ',' near %d", this.tokenizer.currentPos()));
        } while (d != Delimiter.CLOSE);
        return plh;
    }

    protected Delimiter matchesDelimiter() {
        Optional<Character> match = this.tokenizer.matchesOneOf('(', ')', ',');
        if (match.isPresent()) {
            switch (match.get().charValue()) {
                case ',': {
                    return Delimiter.SEP;
                }
                case '(': {
                    return Delimiter.OPEN;
                }
                case ')': {
                    return Delimiter.CLOSE;
                }
            }
            return Delimiter.NO_DELIM;
        }
        return Delimiter.NO_DELIM;
    }

    static enum Delimiter {
        CLOSE,
        OPEN,
        SEP,
        NO_DELIM;

    }
}

