/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class WriteReturnAddressNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<WriteReturnAddressNode> TYPE = NodeClass.create(WriteReturnAddressNode.class);
    @Node.Input
    protected ValueNode value;

    protected WriteReturnAddressNode(ValueNode value) {
        super(TYPE, StampFactory.forVoid());
        this.value = value;
    }

    public void generate(NodeLIRBuilderTool gen) {
        TargetDescription target = gen.getLIRGeneratorTool().target();
        assert (target.arch.getReturnAddressSize() > 0);
        LIRKind wordKind = LIRKind.fromJavaKind((Architecture)target.arch, (JavaKind)target.wordJavaKind);
        gen.getLIRGeneratorTool().emitMove((AllocatableValue)StackSlot.get((ValueKind)wordKind, (int)(-target.arch.getReturnAddressSize()), (boolean)true), gen.operand((Node)this.value));
    }

    @Node.NodeIntrinsic
    public static native void writeReturnAddress(Pointer var0);
}

