/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodeReferenceMapEncoder
extends ReferenceMapEncoder {
    @Override
    protected void encodeAll(List<Map.Entry<ReferenceMapEncoder.Input, Long>> sortedEntries) {
        assert (0L == this.writeBuffer.getBytesWritten());
        this.encodeEndOfTable();
        for (Map.Entry<ReferenceMapEncoder.Input, Long> entry : sortedEntries) {
            ReferenceMapEncoder.Input map = entry.getKey();
            this.encodings.put(map, this.encode(map.getOffsets()));
        }
    }

    private long encode(ReferenceMapEncoder.OffsetIterator offsets) {
        int compressedSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        int uncompressedSize = FrameAccess.uncompressedReferenceSize();
        long startIndex = this.writeBuffer.getBytesWritten();
        int run = 0;
        int gap = 0;
        boolean expectedCompressed = false;
        int expectedOffset = 0;
        while (offsets.hasNext()) {
            int size;
            boolean compressed = offsets.isNextCompressed();
            boolean derived = offsets.isNextDerived();
            int offset = offsets.nextInt();
            if (offset == expectedOffset && compressed == expectedCompressed && !derived) {
                ++run;
            } else {
                assert (offset >= expectedOffset) : "values must be strictly increasing";
                if (run > 0) {
                    this.encodeRun(gap, run, expectedCompressed, false);
                }
                gap = offset - expectedOffset;
                run = 1;
            }
            int n = size = compressed ? compressedSize : uncompressedSize;
            if (derived) {
                this.encodeDerivedRun(gap, offset, offsets.getDerivedOffsets(offset), compressed, size);
                run = 0;
                gap = 0;
            }
            expectedOffset = offset + size;
            expectedCompressed = compressed;
        }
        if (run > 0) {
            this.encodeRun(gap, run, expectedCompressed, false);
        }
        this.encodeEndOfTable();
        return startIndex;
    }

    private void encodeRun(int gap, int refsCount, boolean compressed, boolean derived) {
        assert (gap >= 0 && refsCount >= 0);
        this.writeBuffer.putSV(derived ? (long)(-gap - 1) : (long)gap);
        this.writeBuffer.putSV(compressed ? (long)(-refsCount) : (long)refsCount);
    }

    private void encodeDerivedRun(int gap, int baseOffset, Set<Integer> derivedOffsets, boolean compressed, int size) {
        this.encodeRun(gap, derivedOffsets.size(), compressed, true);
        for (int derivedOffset : derivedOffsets) {
            assert (baseOffset % size == 0 && derivedOffset % size == 0 && derivedOffset != baseOffset);
            this.writeBuffer.putSV((long)((derivedOffset - baseOffset) / size));
        }
    }

    private void encodeEndOfTable() {
        this.encodeRun(0, 0, false, false);
    }
}

