/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.Target_sun_security_provider_NativePRNG;
import com.oracle.svm.core.posix.Target_sun_security_provider_NativePRNG_RandomIO;
import java.io.Closeable;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;

@AutomaticFeature
@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
class NativeSecureRandomFilesCloser
implements Feature {
    NativeSecureRandomFilesCloser() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(NativeSecureRandomFilesCloser::registerShutdownHook, new Object[]{Target_sun_security_provider_NativePRNG.class});
    }

    private static void registerShutdownHook(Feature.DuringAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addTearDownHook(() -> {
            Target_sun_security_provider_NativePRNG_RandomIO instance = Target_sun_security_provider_NativePRNG.INSTANCE;
            if (instance != null) {
                for (Closeable stream : new Closeable[]{instance.nextIn, instance.seedIn, instance.seedOut}) {
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

