/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.hosted.code.CFunctionCallStubMethod;
import com.oracle.svm.hosted.code.CFunctionLinkages;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CFunction;

public class CFunctionSubstitutionProcessor
extends SubstitutionProcessor {
    private final Map<ResolvedJavaMethod, CFunctionCallStubMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, CFunctionCallStubMethod>();

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        ResolvedJavaMethod wrapper = method;
        if (method.isNative() && method.isAnnotationPresent(CFunction.class)) {
            wrapper = this.callWrappers.computeIfAbsent(method, m -> {
                CGlobalDataInfo linkage = CFunctionLinkages.singleton().addOrLookupMethod((ResolvedJavaMethod)m);
                boolean needsTransition = ((CFunction)method.getAnnotation(CFunction.class)).transition() != CFunction.Transition.NO_TRANSITION;
                return new CFunctionCallStubMethod((ResolvedJavaMethod)m, linkage, needsTransition);
            });
        }
        return wrapper;
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof CFunctionCallStubMethod) {
            return ((CFunctionCallStubMethod)method).getOriginal();
        }
        return method;
    }
}

