/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import java.util.IdentityHashMap;
import java.util.function.BiConsumer;

public class JNIThreadOwnedMonitors {
    private static final FastThreadLocalObject<IdentityHashMap> ownedMonitors = FastThreadLocalFactory.createObject(IdentityHashMap.class);

    private static IdentityHashMap<Object, Integer> mutableMap() {
        if (ownedMonitors.get() == null) {
            ownedMonitors.set(new IdentityHashMap());
        }
        return ownedMonitors.get();
    }

    public static void entered(Object obj) {
        IdentityHashMap<Object, Integer> map = JNIThreadOwnedMonitors.mutableMap();
        Integer depth = map.get(obj);
        int newDepth = depth == null ? 1 : depth + 1;
        map.put(obj, newDepth);
    }

    public static void exited(Object obj) {
        IdentityHashMap<Object, Integer> map = JNIThreadOwnedMonitors.mutableMap();
        int depth = map.remove(obj);
        if (depth > 1) {
            map.put(obj, depth - 1);
        }
    }

    public static void forEach(BiConsumer<Object, Integer> action) {
        if (ownedMonitors.get() != null) {
            JNIThreadOwnedMonitors.mutableMap().forEach(action);
        }
    }

    static int ownedMonitorsCount() {
        return ownedMonitors.get() != null ? ownedMonitors.get().size() : 0;
    }
}

