/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi.windows;

import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.LibC;
import com.oracle.svm.core.windows.headers.WinBase;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NFIUnsatisfiedLinkError;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class WindowsTruffleNFISupport
extends TruffleNFISupport {
    static void initialize() {
        ImageSingletons.add(TruffleNFISupport.class, (Object)new WindowsTruffleNFISupport());
    }

    private WindowsTruffleNFISupport() {
        super("_errno");
    }

    @Override
    protected CCharPointer strdupImpl(CCharPointer src) {
        return LibC.strdup(src);
    }

    @Override
    protected long loadLibraryImpl(long nativeContext, String name, int flags) {
        String dllPath = name;
        CTypeConversion.CCharPointerHolder dllpathPin = CTypeConversion.toCString((CharSequence)dllPath);
        CCharPointer dllPathPtr = dllpathPin.get();
        WinBase.HMODULE dlhandle = WinBase.LoadLibraryA((PointerBase)dllPathPtr);
        if (dlhandle.isNull()) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsatisfiedLinkError(WindowsUtils.lastErrorString(dllPath));
        }
        return dlhandle.rawValue();
    }

    @Override
    protected void freeLibraryImpl(long library) {
        WinBase.FreeLibrary(WordFactory.pointer((long)library));
    }

    @Override
    protected long lookupImpl(long nativeContext, long library, String name) {
        PointerBase ret;
        PlatformNativeLibrarySupport nativeLibrarySupport = PlatformNativeLibrarySupport.singleton();
        if (library == 0L) {
            ret = nativeLibrarySupport.findBuiltinSymbol(name);
        } else {
            try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
                ret = WinBase.GetProcAddress((WinBase.HMODULE)WordFactory.pointer((long)library), (PointerBase)symbol.get());
            }
        }
        if (ret.isNull()) {
            CompilerDirectives.transferToInterpreter();
            throw KnownIntrinsics.convertUnknownValue(new Target_com_oracle_truffle_nfi_impl_NFIUnsatisfiedLinkError(WindowsUtils.lastErrorString(name)), UnsatisfiedLinkError.class);
        }
        return ret.rawValue();
    }
}

