/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.jeecgframework.minidao.sqlparser.impl.vo.QueryTable;

public class JSqlTableInfoHelper {
    private static JSqlTableInfoHelper instance = null;
    private static ThreadLocal<Map<String, QueryTable>> threadLocalMap = new ThreadLocal();
    private static ThreadLocal<String> threadLocalMainTableAlias = new ThreadLocal();

    private void init() {
        threadLocalMap.set(new HashMap(5));
        threadLocalMainTableAlias.set(new String());
    }

    private void destroy() {
        threadLocalMap.remove();
        threadLocalMainTableAlias.remove();
    }

    private void addQueryTable(String alias, QueryTable queryTable) {
        threadLocalMap.get().put(alias, queryTable);
    }

    private QueryTable getQueryTable(String alias) {
        return threadLocalMap.get().get(alias);
    }

    private void addQueryTableField(String key, String field) {
        QueryTable queryTable = threadLocalMap.get().get(key);
        if (queryTable == null) {
            queryTable = new QueryTable(key, key);
            threadLocalMap.get().put(key, queryTable);
        }
        queryTable.addField(field);
    }

    private List<QueryTable> getResult() {
        Map<String, QueryTable> localMap = threadLocalMap.get();
        ArrayList<QueryTable> list = new ArrayList<QueryTable>(localMap.values());
        this.destroy();
        return list;
    }

    public static List<QueryTable> getQueryTableInfo(String sql) {
        if (instance == null) {
            instance = new JSqlTableInfoHelper();
        }
        return instance.getQueryTableInfoIns(sql);
    }

    public List<QueryTable> getQueryTableInfoIns(String sql) {
        this.init();
        CCJSqlParserManager parser = new CCJSqlParserManager();
        try {
            Statement stmt = parser.parse((Reader)new StringReader(sql));
            if (stmt instanceof Select) {
                Select selectStatement = (Select)stmt;
                SelectBody selectBody = selectStatement.getSelectBody();
                if (selectBody instanceof PlainSelect) {
                    PlainSelect plainSelect = (PlainSelect)selectBody;
                    this.handleTable(plainSelect);
                    this.handleColumn(plainSelect);
                }
                if (selectBody instanceof SetOperationList) {
                    SetOperationList selectBodyList = (SetOperationList)selectBody;
                    List selects = selectBodyList.getSelects();
                    for (int i = 0; i < selects.size(); ++i) {
                        SelectBody temp = (SelectBody)selects.get(i);
                        if (!(temp instanceof PlainSelect)) continue;
                        PlainSelect plainSelect = (PlainSelect)temp;
                        this.handleTable(plainSelect);
                        this.handleColumn(plainSelect);
                    }
                }
            }
            return this.getResult();
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void handleTable(PlainSelect plainSelect) {
        SelectBody select;
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table table = (Table)plainSelect.getFromItem();
            this.addTableAlias(table);
            List list = plainSelect.getJoins();
            if (list != null) {
                for (Join join : list) {
                    Table joinTable = (Table)join.getRightItem();
                    this.addTableAlias(joinTable);
                }
            }
        } else if (fromItem instanceof SubSelect && (select = ((SubSelect)fromItem).getSelectBody()) instanceof PlainSelect) {
            PlainSelect subSelect = (PlainSelect)select;
            this.handleTable(subSelect);
            this.handleColumn(subSelect);
        }
    }

    private void addTableAlias(Table table) {
        String alias = "";
        alias = table.getAlias() != null ? table.getAlias().getName() : table.getName();
        if (threadLocalMainTableAlias.get().length() == 0) {
            threadLocalMainTableAlias.set(alias);
        }
        this.addQueryTable(alias, new QueryTable(table.getName(), alias));
    }

    private void handleColumn(PlainSelect plainSelect) {
        List list = plainSelect.getSelectItems();
        final String mainTable = threadLocalMainTableAlias.get();
        for (SelectItem selectItem : list) {
            selectItem.accept((SelectItemVisitor)new SelectItemVisitorAdapter(){

                public void visit(SelectExpressionItem item) {
                    Expression exp = item.getExpression();
                    if (exp instanceof Column) {
                        Column c = (Column)exp;
                        if (c.getTable() == null) {
                            String str = c.getColumnName();
                            JSqlTableInfoHelper.this.addQueryTableField(mainTable, str);
                        } else {
                            String tableAlias = c.getTable().getName();
                            QueryTable queryTable = null;
                            queryTable = tableAlias == null || "".equals(tableAlias) ? JSqlTableInfoHelper.this.getQueryTable(mainTable) : JSqlTableInfoHelper.this.getQueryTable(tableAlias);
                            if (queryTable != null) {
                                queryTable.addField(c.getColumnName());
                            }
                        }
                    } else if (exp instanceof SubSelect) {
                        SelectBody selectBody = ((SubSelect)exp).getSelectBody();
                        if (selectBody instanceof PlainSelect) {
                            PlainSelect subSelect = (PlainSelect)selectBody;
                            JSqlTableInfoHelper.this.handleTable(subSelect);
                            JSqlTableInfoHelper.this.handleColumn(subSelect);
                        }
                    } else if (!JSqlTableInfoHelper.this.isSimpleValue(exp)) {
                        String str = exp.toString();
                        boolean isAdded = false;
                        Set keySet = ((Map)threadLocalMap.get()).keySet();
                        for (String alias : keySet) {
                            String temp = alias + ".";
                            if (str.indexOf(temp) < 0) continue;
                            isAdded = true;
                            JSqlTableInfoHelper.this.addQueryTableField(alias, str);
                        }
                        if (!isAdded) {
                            JSqlTableInfoHelper.this.addQueryTableField(mainTable, str);
                        }
                    }
                }

                public void visit(AllTableColumns columns) {
                    String alias = null;
                    try {
                        alias = columns.getTable().getName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (alias == null) {
                        alias = mainTable;
                    }
                    JSqlTableInfoHelper.this.getQueryTable(alias).setAll(true);
                }

                public void visit(AllColumns columns) {
                    if ("*".equals(columns.toString())) {
                        JSqlTableInfoHelper.this.getQueryTable(mainTable).setAll(true);
                    }
                }
            });
        }
    }

    private boolean isFunction(Expression exp) {
        if (exp != null) {
            return exp instanceof Function || exp instanceof BinaryExpression || exp instanceof CastExpression || exp instanceof CaseExpression;
        }
        return false;
    }

    private boolean isSimpleValue(Expression exp) {
        return exp instanceof StringValue || exp instanceof DoubleValue || exp instanceof LongValue;
    }
}

