/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import jodd.introspector.CtorDescriptor;
import jodd.introspector.Ctors;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.Fields;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.Methods;
import jodd.introspector.Properties;
import jodd.introspector.PropertyDescriptor;
import jodd.util.ClassUtil;

public class ClassDescriptor {
    protected final Class type;
    protected final boolean scanAccessible;
    protected final boolean extendedProperties;
    protected final boolean includeFieldsAsProperties;
    protected final String[] propertyFieldPrefix;
    protected final Class[] interfaces;
    protected final Class[] superclasses;
    private final boolean isArray;
    private final boolean isMap;
    private final boolean isList;
    private final boolean isSet;
    private final boolean isCollection;
    private final boolean isSupplier;
    private boolean isSystemClass;
    private Fields fields;
    private Methods methods;
    private Properties properties;
    private Ctors ctors;

    public ClassDescriptor(Class type, boolean scanAccessible, boolean extendedProperties, boolean includeFieldsAsProperties, String[] propertyFieldPrefix) {
        this.type = type;
        this.scanAccessible = scanAccessible;
        this.extendedProperties = extendedProperties;
        this.includeFieldsAsProperties = includeFieldsAsProperties;
        this.propertyFieldPrefix = propertyFieldPrefix;
        this.isArray = type.isArray();
        this.isMap = ClassUtil.isTypeOf((Class)type, Map.class);
        this.isList = ClassUtil.isTypeOf((Class)type, List.class);
        this.isSet = ClassUtil.isTypeOf((Class)type, Set.class);
        this.isCollection = ClassUtil.isTypeOf((Class)type, Collection.class);
        this.isSupplier = ClassUtil.isTypeOf((Class)type, Supplier.class);
        this.interfaces = ClassUtil.resolveAllInterfaces((Class)type);
        this.superclasses = ClassUtil.resolveAllSuperclasses((Class)type);
        this.isSystemClass = type.getName().startsWith("java.") && !type.getName().startsWith("java.awt.geom.");
    }

    public Class getType() {
        return this.type;
    }

    public boolean isScanAccessible() {
        return this.scanAccessible;
    }

    public boolean isExtendedProperties() {
        return this.extendedProperties;
    }

    public boolean isIncludeFieldsAsProperties() {
        return this.includeFieldsAsProperties;
    }

    public String[] getPropertyFieldPrefix() {
        return this.propertyFieldPrefix;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean isSupplier() {
        return this.isSupplier;
    }

    public boolean isSystemClass() {
        return this.isSystemClass;
    }

    protected Fields getFields() {
        if (this.fields == null) {
            this.fields = new Fields(this);
        }
        return this.fields;
    }

    public FieldDescriptor getFieldDescriptor(String name, boolean declared) {
        FieldDescriptor fieldDescriptor = this.getFields().getFieldDescriptor(name);
        if (fieldDescriptor != null && !fieldDescriptor.matchDeclared(declared)) {
            return null;
        }
        return fieldDescriptor;
    }

    public FieldDescriptor[] getAllFieldDescriptors() {
        return this.getFields().getAllFieldDescriptors();
    }

    protected Methods getMethods() {
        if (this.methods == null) {
            this.methods = new Methods(this);
        }
        return this.methods;
    }

    public MethodDescriptor getMethodDescriptor(String name, boolean declared) {
        MethodDescriptor methodDescriptor = this.getMethods().getMethodDescriptor(name);
        if (methodDescriptor != null && methodDescriptor.matchDeclared(declared)) {
            return methodDescriptor;
        }
        return methodDescriptor;
    }

    public MethodDescriptor getMethodDescriptor(String name, Class[] params, boolean declared) {
        MethodDescriptor methodDescriptor = this.getMethods().getMethodDescriptor(name, params);
        if (methodDescriptor != null && methodDescriptor.matchDeclared(declared)) {
            return methodDescriptor;
        }
        return null;
    }

    public MethodDescriptor[] getAllMethodDescriptors(String name) {
        return this.getMethods().getAllMethodDescriptors(name);
    }

    public MethodDescriptor[] getAllMethodDescriptors() {
        return this.getMethods().getAllMethodDescriptors();
    }

    protected Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties(this);
        }
        return this.properties;
    }

    public PropertyDescriptor getPropertyDescriptor(String name, boolean declared) {
        PropertyDescriptor propertyDescriptor = this.getProperties().getPropertyDescriptor(name);
        if (propertyDescriptor != null && propertyDescriptor.matchDeclared(declared)) {
            return propertyDescriptor;
        }
        return null;
    }

    public PropertyDescriptor[] getAllPropertyDescriptors() {
        return this.getProperties().getAllPropertyDescriptors();
    }

    protected Ctors getCtors() {
        if (this.ctors == null) {
            this.ctors = new Ctors(this);
        }
        return this.ctors;
    }

    public CtorDescriptor getDefaultCtorDescriptor(boolean declared) {
        CtorDescriptor defaultCtor = this.getCtors().getDefaultCtor();
        if (defaultCtor != null && defaultCtor.matchDeclared(declared)) {
            return defaultCtor;
        }
        return null;
    }

    public CtorDescriptor getCtorDescriptor(Class[] args, boolean declared) {
        CtorDescriptor ctorDescriptor = this.getCtors().getCtorDescriptor(args);
        if (ctorDescriptor != null && ctorDescriptor.matchDeclared(declared)) {
            return ctorDescriptor;
        }
        return null;
    }

    public CtorDescriptor[] getAllCtorDescriptors() {
        return this.getCtors().getAllCtorDescriptors();
    }

    public Class[] getAllInterfaces() {
        return this.interfaces;
    }

    public Class[] getAllSuperclasses() {
        return this.superclasses;
    }
}

